/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.openapi.server.context.path", "micronaut.openapi.property.naming.strategy", "micronaut.openapi.views.spec", "micronaut.openapi.target.file", "micronaut.openapi.additional.files", "micronaut.openapi.config.file"})
public class OpenApiApplicationVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<OpenAPIDefinition, Object> {
    public static final String MICRONAUT_OPENAPI_CONFIG_FILE = "micronaut.openapi.config.file";
    public static final String MICRONAUT_OPENAPI_EXPAND_PREFIX = "micronaut.openapi.expand.";
    public static final String MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH = "micronaut.openapi.server.context.path";
    public static final String MICRONAUT_OPENAPI_PROPERTY_NAMING_STRATEGY = "micronaut.openapi.property.naming.strategy";
    public static final String MICRONAUT_OPENAPI_VIEWS_SPEC = "micronaut.openapi.views.spec";
    public static final String MICRONAUT_OPENAPI_TARGET_FILE = "micronaut.openapi.target.file";
    public static final String MICRONAUT_OPENAPI_ADDITIONAL_FILES = "micronaut.openapi.additional.files";
    public static final String OPENAPI_CONFIG_FILE = "openapi.properties";
    private ClassElement classElement;
    private Path projectDirectory;
    private Properties openApiProperties = new Properties();

    public void visitClass(ClassElement element, VisitorContext context) {
        context.info("Generating OpenAPI Documentation");
        try {
            this.readOpenApiConfigFile(context);
        }
        catch (IOException e) {
            context.warn("Fail to read OpenAPI configuration file: " + e.getMessage(), null);
        }
        OpenAPI openAPI = this.readOpenAPI(element, context);
        this.mergeAdditionalSwaggerFiles(element, context, openAPI);
        List<io.swagger.v3.oas.models.tags.Tag> tagList = this.processOpenApiAnnotation((Element)element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, openAPI.getTags());
        openAPI.setTags(tagList);
        List<SecurityRequirement> securityRequirements = this.readSecurityRequirements((Element)element);
        if (openAPI.getSecurity() != null) {
            securityRequirements.addAll(openAPI.getSecurity());
        }
        openAPI.setSecurity(securityRequirements);
        List<io.swagger.v3.oas.models.servers.Server> servers = this.processOpenApiAnnotation((Element)element, context, Server.class, io.swagger.v3.oas.models.servers.Server.class, openAPI.getServers());
        openAPI.setServers(servers);
        this.processSecuritySchemes(element, context);
        Optional attr = context.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
        if (attr.isPresent()) {
            OpenAPI existing = (OpenAPI)attr.get();
            Optional.ofNullable(openAPI.getInfo()).ifPresent(arg_0 -> ((OpenAPI)existing).setInfo(arg_0));
            this.copyOpenAPI(existing, openAPI);
        } else {
            context.put((CharSequence)"io.micronaut.OPENAPI", (Object)openAPI);
        }
        if (Boolean.getBoolean("io.micronaut.OPENAPI_TEST")) {
            testReference = this.resolveOpenAPI(context);
        }
        this.classElement = element;
    }

    private String getConfigurationProperty(String key) {
        return System.getProperty(key, this.openApiProperties.getProperty(key));
    }

    private void mergeAdditionalSwaggerFiles(ClassElement element, VisitorContext context, OpenAPI openAPI) {
        String additionalSwaggerFiles = this.getConfigurationProperty(MICRONAUT_OPENAPI_ADDITIONAL_FILES);
        if (StringUtils.isNotEmpty((CharSequence)additionalSwaggerFiles)) {
            Path directory = this.resolve(context, java.nio.file.Paths.get(additionalSwaggerFiles, new String[0]));
            if (Files.isDirectory(directory, new LinkOption[0])) {
                context.info("Merging Swagger OpenAPI YAML files from location: " + directory);
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, path -> path.toString().endsWith(".yml"));){
                    stream.forEach(path -> {
                        context.info("Reading Swagger OpenAPI YAML file " + path.getFileName());
                        OpenAPI parsedOpenApi = null;
                        try {
                            parsedOpenApi = (OpenAPI)this.yamlMapper.readValue(path.toFile(), OpenAPI.class);
                        }
                        catch (IOException e) {
                            context.warn("Unable to read file " + path.getFileName() + ": " + e.getMessage(), (Element)element);
                        }
                        this.copyOpenAPI(openAPI, parsedOpenApi);
                    });
                }
                catch (IOException e) {
                    context.warn("Unable to read  file from " + directory + ": " + e.getMessage(), (Element)element);
                }
            } else {
                context.warn(directory + " does not exist or is not a directory", (Element)element);
            }
        }
    }

    private Path resolve(VisitorContext context, Path path) {
        Path projectDir;
        if (!path.isAbsolute() && (projectDir = this.projectDir(context)) != null) {
            path = projectDir.resolve(path);
        }
        return path.toAbsolutePath();
    }

    private void readOpenApiConfigFile(VisitorContext context) throws IOException {
        String cfgFile = System.getProperty(MICRONAUT_OPENAPI_CONFIG_FILE, OPENAPI_CONFIG_FILE);
        if (StringUtils.isNotEmpty((CharSequence)cfgFile)) {
            Path cfg = this.resolve(context, java.nio.file.Paths.get(cfgFile, new String[0]));
            if (Files.isReadable(cfg)) {
                try (BufferedReader reader = Files.newBufferedReader(cfg);){
                    this.openApiProperties.load(reader);
                }
            } else if (Files.exists(cfg, new LinkOption[0])) {
                context.warn("Can not read configuration file: " + cfg, null);
            }
        }
    }

    private void copyOpenAPI(OpenAPI to, OpenAPI from) {
        if (to != null && from != null) {
            Optional.ofNullable(from.getTags()).ifPresent(tags -> tags.forEach(arg_0 -> ((OpenAPI)to).addTagsItem(arg_0)));
            Optional.ofNullable(from.getServers()).ifPresent(servers -> servers.forEach(arg_0 -> ((OpenAPI)to).addServersItem(arg_0)));
            Optional.ofNullable(from.getSecurity()).ifPresent(securityRequirements -> securityRequirements.forEach(arg_0 -> ((OpenAPI)to).addSecurityItem(arg_0)));
            Optional.ofNullable(from.getPaths()).ifPresent(paths -> paths.forEach((arg_0, arg_1) -> ((OpenAPI)to).path(arg_0, arg_1)));
            Optional.ofNullable(from.getComponents()).ifPresent(components -> {
                Map securitySchemes;
                Map schemas = components.getSchemas();
                if (schemas != null && !schemas.isEmpty()) {
                    schemas.forEach((k, v) -> {
                        if (v.getName() == null) {
                            v.setName(k);
                        }
                    });
                    schemas.forEach((arg_0, arg_1) -> ((OpenAPI)to).schema(arg_0, arg_1));
                }
                if ((securitySchemes = components.getSecuritySchemes()) != null && !securitySchemes.isEmpty()) {
                    securitySchemes.forEach((arg_0, arg_1) -> ((OpenAPI)to).schemaRequirement(arg_0, arg_1));
                }
            });
            Optional.ofNullable(from.getExternalDocs()).ifPresent(arg_0 -> ((OpenAPI)to).externalDocs(arg_0));
            Optional.ofNullable(from.getExtensions()).ifPresent(extensions -> extensions.forEach((arg_0, arg_1) -> ((OpenAPI)to).addExtension(arg_0, arg_1)));
        }
    }

    private OpenAPI readOpenAPI(ClassElement element, VisitorContext context) {
        return element.findAnnotation(OpenAPIDefinition.class).flatMap(o -> {
            Optional<OpenAPI> result = this.toValue(o.getValues(), context, OpenAPI.class);
            result.ifPresent(openAPI -> {
                List securityRequirements = o.getAnnotations("security", io.swagger.v3.oas.annotations.security.SecurityRequirement.class).stream().map(this::mapToSecurityRequirement).collect(Collectors.toList());
                openAPI.setSecurity(securityRequirements);
            });
            return result;
        }).orElse(new OpenAPI());
    }

    private void renderViews(String title, String specFile, Path destinationDir, VisitorContext visitorContext) throws IOException {
        String viewSpecification = System.getProperty(MICRONAUT_OPENAPI_VIEWS_SPEC);
        OpenApiViewConfig cfg = OpenApiViewConfig.fromSpecification(viewSpecification, this.openApiProperties);
        if (cfg.isEnabled()) {
            cfg.setTitle(title);
            cfg.setSpecFile(specFile);
            cfg.setServerContextPath(this.getConfigurationProperty(MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH));
            cfg.render(destinationDir.resolve("views"), visitorContext);
        }
    }

    private static PropertyNamingStrategy.PropertyNamingStrategyBase fromName(String name) {
        if (name == null) {
            return null;
        }
        switch (name.toUpperCase(Locale.US)) {
            case "SNAKE_CASE": {
                return (PropertyNamingStrategy.PropertyNamingStrategyBase)PropertyNamingStrategy.SNAKE_CASE;
            }
            case "UPPER_CAMEL_CASE": {
                return (PropertyNamingStrategy.PropertyNamingStrategyBase)PropertyNamingStrategy.UPPER_CAMEL_CASE;
            }
            case "LOWER_CAMEL_CASE": {
                return (PropertyNamingStrategy.PropertyNamingStrategyBase)PropertyNamingStrategy.LOWER_CAMEL_CASE;
            }
            case "LOWER_CASE": {
                return (PropertyNamingStrategy.PropertyNamingStrategyBase)PropertyNamingStrategy.LOWER_CASE;
            }
            case "KEBAB_CASE": {
                return (PropertyNamingStrategy.PropertyNamingStrategyBase)PropertyNamingStrategy.KEBAB_CASE;
            }
        }
        return null;
    }

    private Optional<Path> openApiSpecFile(String fileName, VisitorContext visitorContext) {
        URI uri;
        Optional<Path> path = this.userDefinedSpecFile(visitorContext);
        if (path.isPresent()) {
            return path;
        }
        Optional generatedFile = visitorContext.visitMetaInfFile("swagger/" + fileName);
        if (generatedFile.isPresent() && (uri = ((GeneratedFile)generatedFile.get()).toURI()).getScheme() != null && !uri.getScheme().equals("mem")) {
            Path specPath = java.nio.file.Paths.get(uri);
            OpenApiApplicationVisitor.createDirectories(specPath, visitorContext);
            return Optional.of(specPath);
        }
        visitorContext.warn("Unable to get swagger/" + fileName + " file.", null);
        return Optional.empty();
    }

    private Path projectDir(VisitorContext visitorContext) {
        URI uri;
        if (this.projectDirectory != null) {
            return this.projectDirectory;
        }
        Optional dummyFile = visitorContext.visitGeneratedFile("dummy");
        if (dummyFile.isPresent() && (uri = ((GeneratedFile)dummyFile.get()).toURI()).getScheme() != null && !uri.getScheme().equals("mem")) {
            for (Path dummy = java.nio.file.Paths.get(uri).normalize(); dummy != null; dummy = dummy.getParent()) {
                Path dummyFileName = dummy.getFileName();
                if (dummyFileName == null || !"build".equals(dummyFileName.toString())) continue;
                this.projectDirectory = dummy.getParent();
                break;
            }
        }
        return this.projectDirectory;
    }

    private Optional<Path> userDefinedSpecFile(VisitorContext visitorContext) {
        String targetFile = this.getConfigurationProperty(MICRONAUT_OPENAPI_TARGET_FILE);
        if (StringUtils.isEmpty((CharSequence)targetFile)) {
            return Optional.empty();
        }
        Path specFile = this.resolve(visitorContext, java.nio.file.Paths.get(targetFile, new String[0]));
        OpenApiApplicationVisitor.createDirectories(specFile, visitorContext);
        return Optional.of(specFile);
    }

    private static void createDirectories(Path f, VisitorContext visitorContext) {
        if (f.getParent() != null) {
            try {
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                visitorContext.warn("Fail to create directories for" + f + ": " + e.getMessage(), null);
            }
        }
    }

    private void applyPropertyNamingStrategy(OpenAPI openAPI, VisitorContext visitorContext) {
        String namingStrategyName = this.getConfigurationProperty(MICRONAUT_OPENAPI_PROPERTY_NAMING_STRATEGY);
        PropertyNamingStrategy.PropertyNamingStrategyBase propertyNamingStrategy = OpenApiApplicationVisitor.fromName(namingStrategyName);
        if (propertyNamingStrategy != null) {
            visitorContext.info("Using " + namingStrategyName + " property naming strategy.");
            openAPI.getComponents().getSchemas().values().forEach(model -> {
                Map properties = model.getProperties();
                if (properties == null) {
                    return;
                }
                Map newProperties = properties.entrySet().stream().collect(Collectors.toMap(entry -> propertyNamingStrategy.translate((String)entry.getKey()), Map.Entry::getValue, (prop1, prop2) -> prop1, LinkedHashMap::new));
                model.getProperties().clear();
                model.setProperties(newProperties);
            });
        }
    }

    private void applyPropertyServerContextPath(OpenAPI openAPI, VisitorContext visitorContext) {
        String serverContextPath = this.getConfigurationProperty(MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH);
        if (serverContextPath == null || serverContextPath.isEmpty()) {
            return;
        }
        visitorContext.info("Applying server context path: " + serverContextPath + " to Paths.");
        Paths paths = openAPI.getPaths();
        if (paths == null || paths.isEmpty()) {
            return;
        }
        Paths newPaths = new Paths();
        for (Map.Entry path : paths.entrySet()) {
            String mapping = (String)path.getKey();
            newPaths.addPathItem(mapping.startsWith(serverContextPath) ? mapping : StringUtils.prependUri((String)serverContextPath, (String)mapping), (PathItem)path.getValue());
        }
        openAPI.setPaths(newPaths);
    }

    private JsonNode resolvePlaceholders(ArrayNode anode, UnaryOperator<String> propertyExpander) {
        for (int i = 0; i < anode.size(); ++i) {
            anode.set(i, this.resolvePlaceholders(anode.get(i), propertyExpander));
        }
        return anode;
    }

    private JsonNode resolvePlaceholders(ObjectNode onode, UnaryOperator<String> propertyExpander) {
        if (onode.size() == 0) {
            return onode;
        }
        ObjectNode newNode = onode.objectNode();
        Iterator i = onode.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            newNode.set((String)propertyExpander.apply((String)entry.getKey()), this.resolvePlaceholders((JsonNode)entry.getValue(), propertyExpander));
        }
        return newNode;
    }

    private JsonNode resolvePlaceholders(JsonNode node, UnaryOperator<String> propertyExpander) {
        if (node.isTextual()) {
            String text = node.textValue();
            if (text == null || text.trim().isEmpty()) {
                return node;
            }
            String newText = (String)propertyExpander.apply(text);
            return text.equals(newText) ? node : TextNode.valueOf((String)newText);
        }
        if (node.isArray()) {
            return this.resolvePlaceholders((ArrayNode)node, propertyExpander);
        }
        if (node.isObject()) {
            return this.resolvePlaceholders((ObjectNode)node, propertyExpander);
        }
        return node;
    }

    private String expandProperties(String s, List<Map.Entry<String, String>> properties) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        for (Map.Entry<String, String> entry : properties) {
            s = s.replace(entry.getKey(), entry.getValue());
        }
        return s;
    }

    private OpenAPI resolvePropertyPlaceHolders(OpenAPI openAPI, VisitorContext visitorContext) {
        List expandableProperties = this.openApiProperties.entrySet().stream().filter(entry -> entry.getKey().toString().startsWith(MICRONAUT_OPENAPI_EXPAND_PREFIX)).map(entry -> new AbstractMap.SimpleImmutableEntry<String, String>("${" + entry.getKey().toString().substring(MICRONAUT_OPENAPI_EXPAND_PREFIX.length()) + '}', entry.getValue().toString())).collect(Collectors.toList());
        if (expandableProperties.isEmpty()) {
            return openAPI;
        }
        visitorContext.info("Expanding properties: " + expandableProperties);
        JsonNode root = this.resolvePlaceholders((ObjectNode)Yaml.mapper().convertValue((Object)openAPI, ObjectNode.class), s -> this.expandProperties((String)s, expandableProperties));
        return (OpenAPI)Yaml.mapper().convertValue((Object)root, OpenAPI.class);
    }

    public void finish(VisitorContext visitorContext) {
        if (this.classElement == null) {
            return;
        }
        Optional attr = visitorContext.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
        attr.ifPresent(openAPI -> {
            Optional<Path> specFile;
            this.applyPropertyNamingStrategy((OpenAPI)openAPI, visitorContext);
            this.applyPropertyServerContextPath((OpenAPI)openAPI, visitorContext);
            openAPI = this.resolvePropertyPlaceHolders((OpenAPI)openAPI, visitorContext);
            String fileName = "swagger.yml";
            String documentTitle = "OpenAPI";
            Info info = openAPI.getInfo();
            if (info != null) {
                documentTitle = Optional.ofNullable(info.getTitle()).orElse("application");
                documentTitle = documentTitle.toLowerCase(Locale.US).replace(' ', '-');
                String version = info.getVersion();
                if (version != null) {
                    documentTitle = documentTitle + '-' + version;
                }
                fileName = documentTitle + ".yml";
            }
            if ((specFile = this.openApiSpecFile(fileName, visitorContext)).isPresent()) {
                Path specPath = specFile.get();
                try (BufferedWriter writer = Files.newBufferedWriter(specPath, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                    visitorContext.info("Writing OpenAPI YAML to destination: " + specPath);
                    this.yamlMapper.writeValue((Writer)writer, openAPI);
                    this.renderViews(documentTitle, fileName, specPath.getParent(), visitorContext);
                }
                catch (Exception e) {
                    visitorContext.warn("Unable to generate swagger.yml: " + specPath + " - " + e.getMessage(), (Element)this.classElement);
                }
            }
        });
    }
}

