/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.PublicMethodVisitor;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElementExt;
import io.micronaut.annotation.processing.visitor.JavaParameterElement;
import io.micronaut.annotation.processing.visitor.JavaPropertyElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.annotation.processing.visitor.JavaVoidElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class JavaClassElementExt
extends JavaClassElement {
    private final JavaClassElement javaClassElement;
    private final TypeElement classElement;
    private final JavaVisitorContext visitorContext;
    private Map<String, Map<String, TypeMirror>> genericTypeInfo;

    public JavaClassElementExt(ClassElement ce, VisitorContext visitorContext) {
        this((JavaClassElement)ce, (JavaVisitorContext)visitorContext);
    }

    private JavaClassElementExt(JavaClassElement jce, JavaVisitorContext visitorContext) {
        super((TypeElement)jce.getNativeType(), jce.getAnnotationMetadata(), visitorContext);
        this.javaClassElement = jce;
        this.classElement = (TypeElement)jce.getNativeType();
        this.visitorContext = visitorContext;
        this.genericTypeInfo = jce.getGenericTypeInfo();
    }

    private static boolean sameType(String type, DeclaredType dt) {
        Element elt = dt.asElement();
        return elt instanceof TypeElement && type.equals(((TypeElement)elt).getQualifiedName().toString());
    }

    public static ClassElement getReturnType(MethodElement method, VisitorContext visitorContext) {
        boolean isSuspend;
        ParameterElement[] parameters = method.getParameters();
        boolean bl = isSuspend = parameters.length > 0 && parameters[parameters.length - 1].getGenericType().isAssignable("kotlin.coroutines.Continuation");
        if (isSuspend) {
            return JavaClassElementExt.continuationReturnType(parameters[parameters.length - 1], visitorContext, Collections.emptyMap());
        }
        return method.getReturnType();
    }

    public static ClassElement getGenericReturnType(MethodElement method, VisitorContext visitorContext) {
        boolean isSuspend;
        ParameterElement[] parameters = method.getParameters();
        boolean bl = isSuspend = parameters.length > 0 && parameters[parameters.length - 1].getGenericType().isAssignable("kotlin.coroutines.Continuation");
        if (isSuspend) {
            return JavaClassElementExt.continuationReturnType(parameters[parameters.length - 1], visitorContext, ((JavaClassElement)method.getOwningType()).getGenericTypeInfo());
        }
        return method.getGenericReturnType();
    }

    private static ClassElement continuationReturnType(ParameterElement parameter, VisitorContext visitorContext, Map<String, Map<String, TypeMirror>> info) {
        JavaVisitorContext jcontext = (JavaVisitorContext)visitorContext;
        VariableElement varElement = (VariableElement)parameter.getNativeType();
        DeclaredType dType = (DeclaredType)varElement.asType();
        WildcardType wType = (WildcardType)dType.getTypeArguments().iterator().next();
        TypeMirror tm = wType.getSuperBound();
        if (tm instanceof DeclaredType && JavaClassElementExt.sameType("kotlin.Unit", (DeclaredType)tm)) {
            return new JavaVoidElement();
        }
        return ((JavaParameterElement)parameter).parameterizedClassElement(tm, jcontext, info);
    }

    private static String findDocumentation(Set<TypeMirror> superTypes, ExecutableElement method, Elements elements, Types types) {
        String doc = elements.getDocComment(method);
        if (doc == null) {
            for (TypeMirror tm : superTypes) {
                TypeElement te = (TypeElement)types.asElement(tm);
                for (ExecutableElement m : ElementFilter.methodsIn(te.getEnclosedElements())) {
                    if (!method.equals(m) && !elements.hides(method, m) && !elements.overrides(method, m, (TypeElement)method.getEnclosingElement())) continue;
                    doc = elements.getDocComment(m);
                    break;
                }
                if (doc == null) continue;
                break;
            }
        }
        return doc;
    }

    private static Set<TypeMirror> superTypes(TypeElement typeElement, Types types) {
        TypeElement te;
        List<? extends TypeMirror> superTypes = types.directSupertypes(typeElement.asType());
        LinkedHashSet<TypeMirror> typeMirrors = new LinkedHashSet<TypeMirror>();
        for (TypeMirror typeMirror : superTypes) {
            te = (TypeElement)types.asElement(typeMirror);
            if (te.getKind() == ElementKind.CLASS && te.getSuperclass().getKind() == TypeKind.NONE) continue;
            typeMirrors.add(typeMirror);
        }
        for (TypeMirror typeMirror : superTypes) {
            te = (TypeElement)types.asElement(typeMirror);
            if (te.getKind() == ElementKind.CLASS && te.getSuperclass().getKind() == TypeKind.NONE) continue;
            typeMirrors.addAll(JavaClassElementExt.superTypes((TypeElement)types.asElement(typeMirror), types));
        }
        return typeMirrors;
    }

    private static boolean isObjectClassMethod(ExecutableElement method, Elements elements) {
        TypeElement te = (TypeElement)method.getEnclosingElement();
        return te.equals(elements.getTypeElement("java.lang.Object"));
    }

    private static boolean isCandidateMethod(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        return !modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.PRIVATE) && !method.getSimpleName().toString().contains("$");
    }

    public List<MethodElement> getCandidateMethods() {
        Elements elements = this.visitorContext.getElements();
        Types types = this.visitorContext.getTypes();
        AnnotationUtils annotations = this.visitorContext.getAnnotationUtils();
        Set<TypeMirror> superTypes = JavaClassElementExt.superTypes(this.classElement, types);
        return ElementFilter.methodsIn(elements.getAllMembers(this.classElement)).stream().filter(method -> !JavaClassElementExt.isObjectClassMethod(method, elements)).filter(JavaClassElementExt::isCandidateMethod).map(method -> new JavaMethodElementExt(this.javaClassElement, (ExecutableElement)method, annotations.getAnnotationMetadata((Element)method), this.visitorContext, JavaClassElementExt.findDocumentation(superTypes, method, elements, types))).collect(Collectors.toList());
    }

    public List<PropertyElement> getFluentBeanProperties() {
        ArrayList<BeanPropertyData> props = new ArrayList<BeanPropertyData>();
        LinkedHashMap<String, VariableElement> fields = new LinkedHashMap<String, VariableElement>();
        HashSet fieldNames = new HashSet();
        this.classElement.asType().accept(new FluentBeanPropertiesVisitor(this.visitorContext.getTypes(), fieldNames, props, fields), null);
        return this.processFields(props, fields);
    }

    private List<PropertyElement> processFields(List<BeanPropertyData> props, Map<String, VariableElement> fields) {
        if (props.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<1> propertyElements = new ArrayList<1>();
        for (final BeanPropertyData value : props) {
            String propertyName = value.propertyName;
            if (value.getter == null) continue;
            VariableElement fieldElement = fields.get(propertyName);
            final AnnotationMetadata annotationMetadata = fieldElement == null ? this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod((Object)value.getter) : this.visitorContext.getAnnotationUtils().getAnnotationMetadata((Element)fieldElement, (Element)value.getter);
            JavaPropertyElement propertyElement = new JavaPropertyElement((ClassElement)(value.declaringType == null ? this.javaClassElement : value.declaringType), value.getter, annotationMetadata, propertyName, value.type, value.setter == null, this.visitorContext){

                public Optional<String> getDocumentation() {
                    Elements elements = JavaClassElementExt.this.visitorContext.getElements();
                    String docComment = elements.getDocComment(value.getter);
                    return Optional.ofNullable(docComment);
                }

                public Optional<MethodElement> getWriteMethod() {
                    if (value.setter != null) {
                        return Optional.of(new JavaMethodElement(JavaClassElementExt.this.javaClassElement, value.setter, JavaClassElementExt.this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod((Object)value.setter), JavaClassElementExt.this.visitorContext));
                    }
                    return Optional.empty();
                }

                public Optional<MethodElement> getReadMethod() {
                    return Optional.of(new JavaMethodElement(JavaClassElementExt.this.javaClassElement, value.getter, annotationMetadata, JavaClassElementExt.this.visitorContext));
                }
            };
            propertyElements.add(propertyElement);
        }
        return Collections.unmodifiableList(propertyElements);
    }

    private static class BeanPropertyData {
        ClassElement type;
        ClassElement declaringType;
        ExecutableElement getter;
        ExecutableElement setter;
        final String propertyName;

        BeanPropertyData(String propertyName) {
            this.propertyName = propertyName;
        }
    }

    private final class FluentBeanPropertiesVisitor
    extends PublicMethodVisitor<Object, Object> {
        private final Set<String> fieldNames;
        private final List<BeanPropertyData> props;
        private final Map<String, VariableElement> fields;

        private FluentBeanPropertiesVisitor(Types types, Set<String> fieldNames, List<BeanPropertyData> props, Map<String, VariableElement> fields) {
            super(types);
            this.fieldNames = fieldNames;
            this.props = props;
            this.fields = fields;
        }

        protected boolean isAcceptable(Element element) {
            Set<Modifier> modifiers;
            if (element.getKind() == ElementKind.FIELD) {
                this.fieldNames.add(element.getSimpleName().toString());
                return true;
            }
            if (element.getKind() == ElementKind.METHOD && element instanceof ExecutableElement && (modifiers = element.getModifiers()).contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.ABSTRACT)) {
                ExecutableElement executableElement = (ExecutableElement)element;
                String methodName = executableElement.getSimpleName().toString();
                if (methodName.contains("$")) {
                    return false;
                }
                return executableElement.getParameters().isEmpty() || executableElement.getParameters().size() == 1;
            }
            return false;
        }

        private BeanPropertyData computeIfAbsent(String propertyName) {
            for (BeanPropertyData bpd : this.props) {
                if (!propertyName.equals(bpd.propertyName)) continue;
                return bpd;
            }
            BeanPropertyData bpd = new BeanPropertyData(propertyName);
            this.props.add(bpd);
            return bpd;
        }

        protected void accept(DeclaredType declaringType, Element element, Object o) {
            if (element instanceof VariableElement) {
                this.fields.put(element.getSimpleName().toString(), (VariableElement)element);
                return;
            }
            String methodName = element.getSimpleName().toString();
            if (!this.fieldNames.contains(methodName)) {
                return;
            }
            ExecutableElement executableElement = (ExecutableElement)element;
            TypeElement declaringTypeElement = (TypeElement)executableElement.getEnclosingElement();
            if (executableElement.getParameters().isEmpty()) {
                this.processGetter(methodName, executableElement, declaringTypeElement);
            } else if (executableElement.getParameters().size() == 1) {
                this.processSetter(methodName, executableElement, declaringTypeElement);
            }
        }

        private void processSetter(String methodName, ExecutableElement executableElement, TypeElement declaringTypeElement) {
            String propertyName = methodName;
            TypeMirror typeMirror = executableElement.getParameters().get(0).asType();
            ClassElement setterParameterType = JavaClassElementExt.this.mirrorToClassElement(typeMirror, JavaClassElementExt.this.visitorContext, JavaClassElementExt.this.genericTypeInfo);
            BeanPropertyData beanPropertyData = this.computeIfAbsent(propertyName);
            this.configureDeclaringType(declaringTypeElement, beanPropertyData);
            ClassElement propertyType = beanPropertyData.type;
            if (propertyType == null) {
                beanPropertyData.setter = executableElement;
            } else if (propertyType.getName().equals(setterParameterType.getName())) {
                beanPropertyData.setter = executableElement;
            }
        }

        private void processGetter(String methodName, ExecutableElement executableElement, TypeElement declaringTypeElement) {
            TypeMirror typeMirror;
            ClassElement setterParameterType;
            ClassElement getterReturnType;
            String propertyName = methodName;
            TypeMirror returnType = executableElement.getReturnType();
            if (returnType instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)returnType;
                String tvn = tv.toString();
                ClassElement clElement = (ClassElement)JavaClassElementExt.this.getTypeArguments().get(tvn);
                getterReturnType = clElement == null ? JavaClassElementExt.this.mirrorToClassElement(returnType, JavaClassElementExt.this.visitorContext, JavaClassElementExt.this.genericTypeInfo) : clElement;
            } else {
                getterReturnType = JavaClassElementExt.this.mirrorToClassElement(returnType, JavaClassElementExt.this.visitorContext, JavaClassElementExt.this.genericTypeInfo);
            }
            BeanPropertyData beanPropertyData = this.computeIfAbsent(propertyName);
            this.configureDeclaringType(declaringTypeElement, beanPropertyData);
            beanPropertyData.type = getterReturnType;
            beanPropertyData.getter = executableElement;
            if (beanPropertyData.setter != null && !(setterParameterType = JavaClassElementExt.this.mirrorToClassElement(typeMirror = beanPropertyData.setter.getParameters().get(0).asType(), JavaClassElementExt.this.visitorContext, JavaClassElementExt.this.genericTypeInfo)).getName().equals(getterReturnType.getName())) {
                beanPropertyData.setter = null;
            }
        }

        private void configureDeclaringType(TypeElement declaringTypeElement, BeanPropertyData beanPropertyData) {
            if (beanPropertyData.declaringType == null && !JavaClassElementExt.this.classElement.equals(declaringTypeElement)) {
                beanPropertyData.declaringType = JavaClassElementExt.this.mirrorToClassElement(declaringTypeElement.asType(), JavaClassElementExt.this.visitorContext, JavaClassElementExt.this.genericTypeInfo);
            }
        }
    }
}

