/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.value.OptionalValues;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.AbstractOpenApiEndpointVisitor;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class OpenApiControllerVisitor
extends AbstractOpenApiEndpointVisitor<Controller, HttpMethodMapping>
implements TypeElementVisitor<Controller, HttpMethodMapping> {
    @Override
    protected boolean ignore(ClassElement element, VisitorContext context) {
        return !element.isAnnotationPresent(Controller.class);
    }

    @Override
    protected boolean ignore(MethodElement element, VisitorContext context) {
        return element.isPrivate() || element.isStatic() || element.isAnnotationPresent(Hidden.class);
    }

    @Override
    protected HttpMethod httpMethod(MethodElement element) {
        Optional httpMethodOpt = element.getAnnotationTypeByStereotype(HttpMethodMapping.class);
        if (!httpMethodOpt.isPresent()) {
            return null;
        }
        try {
            return HttpMethod.valueOf((String)((Class)httpMethodOpt.get()).getSimpleName().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    protected List<MediaType> consumesMediaTypes(MethodElement element) {
        return this.mediaTypes(element, Consumes.class);
    }

    @Override
    protected List<MediaType> producesMediaTypes(MethodElement element) {
        return this.mediaTypes(element, Produces.class);
    }

    private List<MediaType> mediaTypes(MethodElement element, Class<? extends Annotation> ann) {
        OptionalValues mts = element.getValues(ann, List.class);
        if (mts.isEmpty()) {
            return Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);
        }
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mts.forEach((key, list) -> list.stream().map(mt -> MediaType.of((CharSequence)mt.toString())).forEach(mt -> mediaTypes.add((MediaType)mt)));
        return mediaTypes;
    }

    @Override
    protected List<UriMatchTemplate> uriMatchTemplates(MethodElement element) {
        String controllerValue = element.getOwningType().getValue(UriMapping.class, String.class).orElse(element.getDeclaringType().getValue(UriMapping.class, String.class).orElse("/"));
        controllerValue = this.getPropertyPlaceholderResolver().resolvePlaceholders(controllerValue).orElse(controllerValue);
        UriMatchTemplate matchTemplate = UriMatchTemplate.of((String)controllerValue);
        String[] uris = element.stringValues(HttpMethodMapping.class, "uris");
        if (uris.length == 0) {
            String methodValue = element.getValue(HttpMethodMapping.class, String.class).orElse("/");
            methodValue = this.getPropertyPlaceholderResolver().resolvePlaceholders(methodValue).orElse(methodValue);
            return Collections.singletonList(matchTemplate.nest((CharSequence)methodValue));
        }
        ArrayList<UriMatchTemplate> matchTemplates = new ArrayList<UriMatchTemplate>(uris.length);
        for (String methodValue : uris) {
            methodValue = this.getPropertyPlaceholderResolver().resolvePlaceholders(methodValue).orElse(methodValue);
            matchTemplates.add(matchTemplate.nest((CharSequence)methodValue));
        }
        return matchTemplates;
    }

    @Override
    protected String description(MethodElement element) {
        return null;
    }

    @Override
    protected List<Tag> classTags(ClassElement element, VisitorContext context) {
        return Collections.emptyList();
    }

    @Override
    protected List<Server> methodServers(MethodElement element, VisitorContext context) {
        return this.processOpenApiAnnotation((Element)element, context, io.swagger.v3.oas.annotations.servers.Server.class, Server.class, Collections.emptyList());
    }

    @Override
    protected List<SecurityRequirement> methodSecurityRequirements(MethodElement element, VisitorContext context) {
        return this.readSecurityRequirements((Element)element);
    }
}

