/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MediaType;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.management.endpoint.annotation.Delete;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import io.micronaut.management.endpoint.annotation.Selector;
import io.micronaut.management.endpoint.annotation.Write;
import io.micronaut.openapi.visitor.AbstractOpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.EndpointsConfiguration;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class OpenApiEndpointVisitor
extends AbstractOpenApiEndpointVisitor<Endpoint, Object>
implements TypeElementVisitor<Endpoint, Object> {
    private String id;
    private boolean skip;
    private HttpMethodDesciption methodDescription;

    @Override
    protected boolean ignore(ClassElement element, VisitorContext context) {
        EndpointsConfiguration cfg = OpenApiApplicationVisitor.endPointsConfiguration(context);
        if (!cfg.isEnabled()) {
            this.skip = true;
            return this.skip;
        }
        boolean endpoint = element.isAnnotationPresent(Endpoint.class);
        if (endpoint) {
            AnnotationValue ann = element.getAnnotation(Endpoint.class);
            this.id = cfg.getPath() + ann.stringValue("id").orElse(NameUtils.hyphenate((String)element.getSimpleName()));
            if (this.id.charAt(0) != '/') {
                this.id = '/' + this.id;
            }
        }
        this.skip = !endpoint;
        return this.skip;
    }

    @Override
    protected boolean ignore(MethodElement element, VisitorContext context) {
        if (this.skip || element.isAnnotationPresent(Hidden.class)) {
            return true;
        }
        this.methodDescription = OpenApiEndpointVisitor.httpMethodDescription(element);
        return this.methodDescription == null;
    }

    @Override
    protected HttpMethod httpMethod(MethodElement element) {
        return this.methodDescription == null ? null : this.methodDescription.httpMethod;
    }

    @Override
    protected List<UriMatchTemplate> uriMatchTemplates(MethodElement element) {
        UriMatchTemplate uriTemplate = UriMatchTemplate.of((String)this.id);
        for (ParameterElement param : element.getParameters()) {
            if (!param.hasAnnotation(Selector.class)) continue;
            uriTemplate = uriTemplate.nest((CharSequence)("/{" + param.getName() + "}"));
        }
        return Collections.singletonList(uriTemplate);
    }

    @Override
    protected List<MediaType> consumesMediaTypes(MethodElement element) {
        return OpenApiEndpointVisitor.mediaTypes(this.methodDescription.consumes);
    }

    @Override
    protected List<MediaType> producesMediaTypes(MethodElement element) {
        return OpenApiEndpointVisitor.mediaTypes(this.methodDescription.produces);
    }

    @Override
    protected String description(MethodElement element) {
        return this.methodDescription.description;
    }

    @Override
    protected List<Tag> classTags(ClassElement element, VisitorContext context) {
        EndpointsConfiguration cfg = OpenApiApplicationVisitor.endPointsConfiguration(context);
        ArrayList<Tag> allTags = new ArrayList<Tag>(cfg.getTags());
        allTags.addAll((Collection)context.get((CharSequence)"micronaut.openapi.endpoint.class.tags", List.class, Collections.emptyList()));
        return allTags;
    }

    @Override
    protected List<Server> methodServers(MethodElement element, VisitorContext context) {
        EndpointsConfiguration cfg = OpenApiApplicationVisitor.endPointsConfiguration(context);
        ArrayList<Server> servers = new ArrayList<Server>(cfg.getServers());
        servers.addAll((Collection)context.get((CharSequence)"micronaut.openapi.endpoint.servers", List.class, Collections.emptyList()));
        return servers;
    }

    @Override
    protected List<SecurityRequirement> methodSecurityRequirements(MethodElement element, VisitorContext context) {
        EndpointsConfiguration cfg = OpenApiApplicationVisitor.endPointsConfiguration(context);
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>(cfg.getSecurityRequirements());
        securityRequirements.addAll((Collection)context.get((CharSequence)"micronaut.openapi.endpoint.security.requirements", List.class, Collections.emptyList()));
        return securityRequirements;
    }

    private static List<MediaType> mediaTypes(String ... arr) {
        if (arr == null || arr.length == 0) {
            return Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);
        }
        return Arrays.stream(arr).map(MediaType::of).collect(Collectors.toList());
    }

    private static HttpMethodDesciption httpMethodDescription(MethodElement element) {
        HttpMethodDesciption httpMethodDescription = OpenApiEndpointVisitor.methodDescription(element, Write.class, HttpMethod.POST);
        if (httpMethodDescription != null) {
            return httpMethodDescription;
        }
        httpMethodDescription = OpenApiEndpointVisitor.methodDescription(element, Read.class, HttpMethod.GET);
        if (httpMethodDescription != null) {
            return httpMethodDescription;
        }
        return OpenApiEndpointVisitor.methodDescription(element, Delete.class, HttpMethod.DELETE);
    }

    private static HttpMethodDesciption methodDescription(MethodElement element, Class<? extends Annotation> ann, HttpMethod httpMethod) {
        Optional httpMethodOpt = element.getAnnotationTypeByStereotype(ann);
        if (httpMethodOpt.isPresent()) {
            AnnotationValue annotation = element.getAnnotation(ann);
            return new HttpMethodDesciption(httpMethod, annotation.stringValue("description").orElse(null), annotation.stringValues("produces"), annotation.stringValues("consumes"));
        }
        return null;
    }

    private static class HttpMethodDesciption {
        HttpMethod httpMethod;
        String description;
        String[] produces;
        String[] consumes;

        HttpMethodDesciption(HttpMethod httpMethod, String description, String[] produces, String[] consumes) {
            this.httpMethod = httpMethod;
            this.description = description;
            this.produces = produces;
            this.consumes = consumes;
        }

        public String toString() {
            return "HttpMethodDesciption [httpMethod=" + this.httpMethod + ", description=" + this.description + ", produces=" + Arrays.toString(this.produces) + ", consumes=" + Arrays.toString(this.consumes) + "]";
        }
    }
}

