/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.picocli;

import io.micronaut.configuration.picocli.MicronautFactory;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.TypeHint;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@TypeHint(value={System.class, Executable.class, Parameter.class, ResourceBundle.class, Path.class, Paths.class}, typeNames={"picocli.CommandLine$AutoHelpMixin"}, accessType={TypeHint.AccessType.ALL_DECLARED_FIELDS, TypeHint.AccessType.ALL_PUBLIC_METHODS})
public class PicocliRunner {
    public static <C extends Callable<T>, T> T call(Class<C> cls, String ... args) throws Exception {
        try (ApplicationContext ctx = ApplicationContext.build(cls, (String[])new String[]{"cli"}).start();){
            T t = PicocliRunner.call(cls, ctx, args);
            return t;
        }
    }

    public static <C extends Callable<T>, T> T call(Class<C> cls, ApplicationContext ctx, String ... args) {
        return (T)CommandLine.call(cls, (CommandLine.IFactory)new MicronautFactory(ctx), (String[])args);
    }

    public static <R extends Runnable> void run(Class<R> cls, String ... args) throws Exception {
        try (ApplicationContext ctx = ApplicationContext.build(cls, (String[])new String[]{"cli"}).start();){
            PicocliRunner.run(cls, ctx, args);
        }
    }

    public static <R extends Runnable> void run(Class<R> cls, ApplicationContext ctx, String ... args) {
        CommandLine.run(cls, (CommandLine.IFactory)new MicronautFactory(ctx), (String[])args);
    }

    public static int execute(Class<?> clazz, String ... args) {
        try (ApplicationContext context = ApplicationContext.build(clazz, (String[])new String[]{"cli"}).start();){
            int n = PicocliRunner.execute(clazz, context, args);
            return n;
        }
    }

    private static int execute(Class<?> clazz, ApplicationContext context, String ... args) {
        return new CommandLine(clazz, (CommandLine.IFactory)new MicronautFactory(context)).execute(args);
    }
}

