/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.rabbitmq.bind;

import io.micronaut.configuration.rabbitmq.bind.RabbitAnnotatedArgumentBinder;
import io.micronaut.configuration.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.configuration.rabbitmq.serdes.RabbitMessageSerDesRegistry;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.messaging.annotation.Body;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class RabbitBodyBinder
implements RabbitAnnotatedArgumentBinder<Body> {
    private final RabbitMessageSerDesRegistry serDesRegistry;

    public RabbitBodyBinder(RabbitMessageSerDesRegistry serDesRegistry) {
        this.serDesRegistry = serDesRegistry;
    }

    public Class<Body> getAnnotationType() {
        return Body.class;
    }

    public ArgumentBinder.BindingResult<Object> bind(ArgumentConversionContext<Object> context, RabbitConsumerState messageState) {
        Argument bodyType = context.getArgument();
        Optional<Object> message = this.serDesRegistry.findSerdes(bodyType).map(serDes -> serDes.deserialize(messageState, bodyType));
        return () -> message;
    }
}

