/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.rabbitmq.bind;

import io.micronaut.configuration.rabbitmq.bind.RabbitAnnotatedArgumentBinder;
import io.micronaut.configuration.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.configuration.rabbitmq.bind.RabbitHeaderConvertibleValues;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.messaging.annotation.Header;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class RabbitHeaderBinder
implements RabbitAnnotatedArgumentBinder<Header> {
    private final ConversionService conversionService;

    public RabbitHeaderBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Class<Header> getAnnotationType() {
        return Header.class;
    }

    public ArgumentBinder.BindingResult<Object> bind(ArgumentConversionContext<Object> context, RabbitConsumerState messageState) {
        String parameterName = context.getAnnotationMetadata().getValue(Header.class, String.class).orElse(context.getArgument().getName());
        Map rawHeaders = messageState.getProperties().getHeaders();
        RabbitHeaderConvertibleValues headers = new RabbitHeaderConvertibleValues(rawHeaders, this.conversionService);
        Optional<Object> header = headers.get(parameterName, context);
        return () -> header;
    }
}

