/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.rabbitmq.bind;

import com.rabbitmq.client.Channel;
import io.micronaut.configuration.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.messaging.exceptions.MessageAcknowledgementException;
import java.io.IOException;
import javax.annotation.Nullable;

public class RabbitMessageCloseable
implements AutoCloseable {
    private final Channel channel;
    private final long deliveryTag;
    private final boolean multiple;
    private final boolean reQueue;
    private Boolean acknowledge = null;

    public RabbitMessageCloseable(RabbitConsumerState consumerState, boolean multiple, boolean reQueue) {
        this.channel = consumerState.getChannel();
        this.deliveryTag = consumerState.getEnvelope().getDeliveryTag();
        this.multiple = multiple;
        this.reQueue = reQueue;
    }

    @Override
    public void close() throws MessageAcknowledgementException {
        if (this.acknowledge != null) {
            if (this.acknowledge.booleanValue()) {
                try {
                    this.channel.basicAck(this.deliveryTag, this.multiple);
                }
                catch (IOException e) {
                    throw new MessageAcknowledgementException("An error occurred acknowledging a message", (Throwable)e);
                }
            }
            try {
                this.channel.basicNack(this.deliveryTag, this.multiple, this.reQueue);
            }
            catch (IOException e) {
                throw new MessageAcknowledgementException("An error occurred rejecting a message", (Throwable)e);
            }
        }
    }

    public RabbitMessageCloseable withAcknowledge(@Nullable Boolean acknowledge) {
        this.acknowledge = acknowledge;
        return this;
    }
}

