/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.rabbitmq.exception;

import io.micronaut.configuration.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.messaging.exceptions.MessageListenerException;
import java.util.Optional;
import javax.annotation.Nullable;

public class RabbitListenerException
extends MessageListenerException {
    private final Object listener;
    private final RabbitConsumerState messageState;

    public RabbitListenerException(String message, Object listener, @Nullable RabbitConsumerState messageState) {
        super(message);
        this.listener = listener;
        this.messageState = messageState;
    }

    public RabbitListenerException(String message, Throwable cause, Object listener, @Nullable RabbitConsumerState messageState) {
        super(message, cause);
        this.listener = listener;
        this.messageState = messageState;
    }

    public RabbitListenerException(Throwable cause, Object listener, @Nullable RabbitConsumerState messageState) {
        super(cause.getMessage(), cause);
        this.listener = listener;
        this.messageState = messageState;
    }

    public Object getListener() {
        return this.listener;
    }

    public Optional<RabbitConsumerState> getMessageState() {
        return Optional.ofNullable(this.messageState);
    }
}

