/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.rabbitmq.health;

import com.rabbitmq.client.Connection;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.AbstractHealthIndicator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Requirements(value={@Requires(property="endpoints.health.rabbitmq.enabled", notEquals="false"), @Requires(beans={HealthEndpoint.class})})
@Singleton
public class RabbitMQHealthIndicator
extends AbstractHealthIndicator<Map<String, Object>> {
    private final Connection connection;

    public RabbitMQHealthIndicator(Connection connection) {
        this.connection = connection;
    }

    protected Map<String, Object> getHealthInformation() {
        if (this.connection.isOpen()) {
            this.healthStatus = HealthStatus.UP;
            return this.connection.getServerProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Object value = entry.getValue();
                if (value instanceof Map) {
                    return value;
                }
                return value.toString();
            }));
        }
        throw new RuntimeException("RabbitMQ connection is not open");
    }

    protected String getName() {
        return "rabbitmq";
    }
}

