/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.security.ldap;

import io.micronaut.configuration.security.ldap.ContextAuthenticationMapper;
import io.micronaut.configuration.security.ldap.configuration.LdapConfiguration;
import io.micronaut.configuration.security.ldap.context.ContextBuilder;
import io.micronaut.configuration.security.ldap.context.LdapSearchResult;
import io.micronaut.configuration.security.ldap.context.LdapSearchService;
import io.micronaut.configuration.security.ldap.group.LdapGroupProcessor;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.AuthenticationFailureReason;
import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.reactivex.Flowable;
import java.io.Closeable;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthenticationProvider
implements AuthenticationProvider,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LdapAuthenticationProvider.class);
    private final LdapConfiguration configuration;
    private final LdapSearchService ldapSearchService;
    private final ContextBuilder contextBuilder;
    private final ContextAuthenticationMapper contextAuthenticationMapper;
    private final LdapGroupProcessor ldapGroupProcessor;

    public LdapAuthenticationProvider(LdapConfiguration configuration, LdapSearchService ldapSearchService, ContextBuilder contextBuilder, ContextAuthenticationMapper contextAuthenticationMapper, LdapGroupProcessor ldapGroupProcessor) {
        this.configuration = configuration;
        this.ldapSearchService = ldapSearchService;
        this.contextBuilder = contextBuilder;
        this.contextAuthenticationMapper = contextAuthenticationMapper;
        this.ldapGroupProcessor = ldapGroupProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Publisher<AuthenticationResponse> authenticate(AuthenticationRequest authenticationRequest) {
        AuthenticationFailed response;
        block27: {
            DirContext managerContext;
            String username = authenticationRequest.getIdentity().toString();
            String password = authenticationRequest.getSecret().toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting authentication with configuration [{}]", (Object)this.configuration.getName());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempting to initialize manager context");
            }
            try {
                managerContext = this.contextBuilder.build(this.configuration.getManagerSettings());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Manager context initialized successfully");
                }
            }
            catch (NamingException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to create manager context. Returning unknown authentication failure. Encountered {}", (Throwable)e);
                }
                return Flowable.just((Object)new AuthenticationFailed(AuthenticationFailureReason.UNKNOWN));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempting to authenticate with user [{}]", (Object)username);
            }
            response = new AuthenticationFailed(AuthenticationFailureReason.USER_NOT_FOUND);
            try {
                Optional<LdapSearchResult> optionalResult = this.ldapSearchService.searchFirst(managerContext, this.configuration.getSearch().getSettings(new Object[]{username}));
                if (optionalResult.isPresent()) {
                    LdapSearchResult result = optionalResult.get();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("User found in context [{}]. Attempting to bind.", (Object)result.getDn());
                    }
                    DirContext userContext = null;
                    try {
                        String dn = result.getDn();
                        userContext = this.contextBuilder.build(this.configuration.getSettings(result.getDn(), password));
                        if (result.getAttributes() == null) {
                            result.setAttributes(userContext.getAttributes(dn));
                        }
                        this.contextBuilder.close(userContext);
                    }
                    catch (Throwable throwable) {
                        this.contextBuilder.close(userContext);
                        throw throwable;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Successfully bound user [{}]. Attempting to retrieving groups.", (Object)result.getDn());
                    }
                    Set<String> groups = Collections.emptySet();
                    LdapConfiguration.GroupConfiguration groupSettings = this.configuration.getGroups();
                    if (groupSettings.isEnabled()) {
                        groups = this.ldapGroupProcessor.process(groupSettings.getAttribute(), result, () -> this.ldapSearchService.search(managerContext, groupSettings.getSearchSettings(new Object[]{result.getDn()})));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Group search returned [{}] for user [{}]", groups, (Object)username);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Group search is disabled for configuration [{}]", (Object)this.configuration.getName());
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Attempting to map [{}] with groups [{}] to an authentication response.", (Object)username, groups);
                    }
                    response = this.contextAuthenticationMapper.map(result.getAttributes(), username, groups);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Response successfully created for [{}]. Response is authenticated: [{}]", (Object)username, (Object)response.isAuthenticated());
                    }
                    break block27;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("User not found [{}]", (Object)username);
                }
            }
            catch (NamingException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to authenticate with user [{}].  {}", (Object)username, (Object)e);
                }
                if (e instanceof AuthenticationException) {
                    response = new AuthenticationFailed(AuthenticationFailureReason.CREDENTIALS_DO_NOT_MATCH);
                }
            }
            finally {
                this.contextBuilder.close(managerContext);
            }
        }
        return Flowable.just((Object)response);
    }

    @Override
    public void close() {
    }
}

