/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.controlpanel.panels.management;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.controlpanel.core.AbstractControlPanel;
import io.micronaut.controlpanel.core.config.ControlPanelConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.management.endpoint.beans.BeansEndpoint;
import io.micronaut.management.endpoint.beans.impl.DefaultBeanDefinitionData;
import io.micronaut.runtime.context.scope.Refreshable;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Singleton
@Refreshable
@Requirements(value={@Requires(beans={BeansEndpoint.class}), @Requires(property="micronaut.control-panel.panels.beans.enabled", notEquals="false")})
public class BeansControlPanel
extends AbstractControlPanel<Body> {
    public static final String NAME = "beans";
    public static final String ENABLED_PROPERTY = "micronaut.control-panel.panels.beans.enabled";
    private static final Function<BeanDefinition<?>, String> BY_PACKAGE = bd -> bd.getBeanType().getPackage().getName();
    private static final Function<BeanDefinition<?>, String> BY_MICRONAUT_PACKAGE = bd -> bd.getBeanType().getPackage().getName().replaceAll("io\\.micronaut\\.(\\w+).*", "$1");
    private static final Comparator<Object> COMPARATOR_BY_NAME = Comparator.comparing(bd -> bd.getClass().getName());
    private static final Predicate<BeanDefinition<?>> IS_MICRONAUT_PACKAGE = bd -> bd.getBeanType().getPackage().getName().startsWith("io.micronaut");
    private final Body body;
    private final long beanDefinitionsCount;

    public BeansControlPanel(BeanContext beanContext, DefaultBeanDefinitionData beanDefinitionData, @Named(value="beans") ControlPanelConfiguration configuration) {
        super(NAME, configuration);
        LinkedHashMap<String, List<Map<String, Object>>> micronautBeansByPackage = this.computeBeansByPackage(beanContext, beanDefinitionData, IS_MICRONAUT_PACKAGE, BY_MICRONAUT_PACKAGE);
        LinkedHashMap<String, List<Map<String, Object>>> otherBeansByPackage = this.computeBeansByPackage(beanContext, beanDefinitionData, IS_MICRONAUT_PACKAGE.negate(), BY_PACKAGE);
        this.body = new Body(micronautBeansByPackage, otherBeansByPackage);
        this.beanDefinitionsCount = beanContext.getAllBeanDefinitions().size();
    }

    public Body getBody() {
        return this.body;
    }

    public String getBadge() {
        return String.valueOf(this.beanDefinitionsCount);
    }

    private LinkedHashMap<String, List<Map<String, Object>>> computeBeansByPackage(BeanContext beanContext, DefaultBeanDefinitionData beanDefinitionData, Predicate<BeanDefinition<?>> filter, Function<BeanDefinition<?>, String> groupBy) {
        return beanContext.getAllBeanDefinitions().stream().filter(filter).sorted(COMPARATOR_BY_NAME).collect(Collectors.groupingBy(groupBy, LinkedHashMap::new, Collectors.mapping(arg_0 -> ((DefaultBeanDefinitionData)beanDefinitionData).getData(arg_0), Collectors.toList())));
    }

    record Body(Map<String, List<Map<String, Object>>> micronautBeansByPackage, Map<String, List<Map<String, Object>>> otherBeansByPackage) {
    }
}

