/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.controlpanel.panels.management;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.controlpanel.core.AbstractControlPanel;
import io.micronaut.controlpanel.core.config.ControlPanelConfiguration;
import io.micronaut.management.endpoint.env.EnvironmentEndpoint;
import io.micronaut.runtime.context.scope.Refreshable;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.stream.StreamSupport;

@Singleton
@Refreshable
@Requirements(value={@Requires(beans={EnvironmentEndpoint.class}), @Requires(property="micronaut.control-panel.panels.env.enabled", notEquals="false")})
public class EnvironmentControlPanel
extends AbstractControlPanel<Map<String, Object>> {
    public static final String NAME = "env";
    public static final String ENABLED_PROPERTY = "micronaut.control-panel.panels.env.enabled";
    private final EnvironmentEndpoint endpoint;
    private final long totalProperties;

    public EnvironmentControlPanel(EnvironmentEndpoint endpoint, Environment environment, @Named(value="env") ControlPanelConfiguration configuration) {
        super(NAME, configuration);
        this.endpoint = endpoint;
        this.totalProperties = environment.getPropertySources().stream().map(ps -> StreamSupport.stream(ps.spliterator(), false).count()).mapToLong(Long::longValue).sum();
    }

    public Map<String, Object> getBody() {
        return this.endpoint.getEnvironmentInfo();
    }

    public String getBadge() {
        return String.valueOf(this.totalProperties);
    }
}

