/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.controlpanel.panels.management;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.controlpanel.core.AbstractControlPanel;
import io.micronaut.controlpanel.core.config.ControlPanelConfiguration;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.HealthResult;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Singleton
@Requirements(value={@Requires(beans={HealthEndpoint.class}), @Requires(property="micronaut.control-panel.panels.health.enabled", notEquals="false")})
public class HealthControlPanel
extends AbstractControlPanel<HealthResult> {
    public static final String NAME = "health";
    public static final String ENABLED_PROPERTY = "micronaut.control-panel.panels.health.enabled";
    private final HealthEndpoint endpoint;

    public HealthControlPanel(HealthEndpoint endpoint, @Named(value="health") ControlPanelConfiguration configuration) {
        super(NAME, configuration);
        this.endpoint = endpoint;
    }

    public HealthResult getBody() {
        return (HealthResult)Mono.from((Publisher)this.endpoint.getHealth(null)).block();
    }
}

