/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.controlpanel.panels.management;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.controlpanel.core.AbstractControlPanel;
import io.micronaut.controlpanel.core.config.ControlPanelConfiguration;
import io.micronaut.logging.LogLevel;
import io.micronaut.management.endpoint.loggers.LoggerConfiguration;
import io.micronaut.management.endpoint.loggers.LoggersEndpoint;
import io.micronaut.management.endpoint.loggers.ManagedLoggingSystem;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Singleton
@Requirements(value={@Requires(beans={LoggersEndpoint.class, ManagedLoggingSystem.class}), @Requires(property="micronaut.control-panel.panels.loggers.enabled", notEquals="false")})
public class LoggersControlPanel
extends AbstractControlPanel<Body> {
    public static final String NAME = "loggers";
    public static final String ENABLED_PROPERTY = "micronaut.control-panel.panels.loggers.enabled";
    private final ManagedLoggingSystem loggingSystem;
    private final List<LogLevel> levels;

    public LoggersControlPanel(ManagedLoggingSystem loggingSystem, @Named(value="loggers") ControlPanelConfiguration configuration) {
        super(NAME, configuration);
        this.loggingSystem = loggingSystem;
        this.levels = Arrays.asList(LogLevel.values());
    }

    public Body getBody() {
        LinkedHashMap loggers = this.getLoggers().sorted(Comparator.comparing(LoggerConfiguration::getName)).collect(Collectors.toMap(LoggerConfiguration::getName, LoggerConfiguration::getData, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        return new Body(this.levels, loggers);
    }

    public String getBadge() {
        return String.valueOf(this.getLoggers().count());
    }

    private Stream<LoggerConfiguration> getLoggers() {
        return this.loggingSystem.getLoggers().stream().filter(loggerConfiguration -> loggerConfiguration.configuredLevel() != LogLevel.NOT_SPECIFIED);
    }

    record Body(List<LogLevel> levels, Map<String, Map<String, Object>> loggers) {
    }
}

