/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.controlpanel.ui.util;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.refresh.RefreshEndpoint;
import io.micronaut.management.endpoint.stop.ServerStopEndpoint;
import java.util.Optional;

@Internal
public final class EndpointUtils {
    private EndpointUtils() {
    }

    public static boolean canRefresh(@Nullable RefreshEndpoint endpoint, BeanContext beanContext) {
        return endpoint != null && !EndpointUtils.isSensitive(endpoint, beanContext);
    }

    public static boolean canStop(@Nullable ServerStopEndpoint endpoint, BeanContext beanContext) {
        return endpoint != null && !EndpointUtils.isSensitive(endpoint, beanContext);
    }

    static boolean isSensitive(Object endpoint, BeanContext beanContext) {
        AnnotationMetadata annotationMetadata = beanContext.resolveMetadata(endpoint);
        Boolean defaultSensitive = annotationMetadata.booleanValue(Endpoint.class, "defaultSensitive").orElse(true);
        String prefix = annotationMetadata.stringValue(Endpoint.class, "prefix").orElse("endpoints");
        String id = annotationMetadata.stringValue(Endpoint.class).orElse(null);
        String defaultId = annotationMetadata.stringValue(Endpoint.class, "defaultConfigurationId").orElse("all");
        if (beanContext instanceof PropertyResolver) {
            PropertyResolver resolver = (PropertyResolver)beanContext;
            Optional sensitive = resolver.getProperty(String.format("%s.%s.sensitive", prefix, id), Boolean.class);
            if (sensitive.isPresent()) {
                return (Boolean)sensitive.get();
            }
            sensitive = resolver.getProperty(String.format("%s.%s.sensitive", prefix, defaultId), Boolean.class);
            return sensitive.orElse(defaultSensitive);
        }
        return defaultSensitive;
    }
}

