/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.controlpanel.ui;

import io.micronaut.context.BeanContext;
import io.micronaut.context.env.Environment;
import io.micronaut.controlpanel.core.ControlPanel;
import io.micronaut.controlpanel.core.ControlPanelRepository;
import io.micronaut.controlpanel.ui.ControlPanelApi;
import io.micronaut.controlpanel.ui.Model;
import io.micronaut.controlpanel.ui.util.EndpointUtils;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.annotation.Controller;
import io.micronaut.management.endpoint.refresh.RefreshEndpoint;
import io.micronaut.management.endpoint.stop.ServerStopEndpoint;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.scheduling.annotation.ExecuteOn;
import io.micronaut.views.View;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Controller(value="${micronaut.control-panel.path:/control-panel}")
@ExecuteOn(value="blocking")
public class ControlPanelController
implements ControlPanelApi {
    private final ControlPanelRepository repository;
    private final String applicationName;
    private final Set<String> activeEnvironments;
    private final boolean canRefresh;
    private final boolean canStop;

    public ControlPanelController(ControlPanelRepository repository, BeanContext beanContext, @Nullable RefreshEndpoint refreshEndpoint, @Nullable ServerStopEndpoint stopEndpoint) {
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)beanContext.getBean(ApplicationConfiguration.class);
        Environment environment = (Environment)beanContext.getBean(Environment.class);
        this.repository = repository;
        this.applicationName = applicationConfiguration.getName().orElse("(unnamed)");
        this.activeEnvironments = environment.getActiveNames();
        this.canRefresh = EndpointUtils.canRefresh(refreshEndpoint, beanContext);
        this.canStop = stopEndpoint != null;
    }

    @Override
    @View(value="layout")
    public Model index() {
        return this.byCategory(ControlPanel.Category.MAIN.id());
    }

    @Override
    @View(value="layout")
    public Model byCategory(String categoryId) {
        HashMap<String, Object> extraProperties = new HashMap<String, Object>();
        List categories = this.repository.findAllCategories();
        List controlPanels = this.repository.findAllByCategory(categoryId);
        extraProperties.put("controlPanels", controlPanels);
        Optional optionalCategory = this.repository.findCategoryById(categoryId);
        optionalCategory.ifPresent(category -> extraProperties.put("currentCategory", category));
        return new Model(categories, this.applicationName, this.activeEnvironments, Model.ContentView.INDEX, this.canRefresh, this.canStop, extraProperties);
    }

    @Override
    @View(value="layout")
    public Model detail(String controlPanelName) {
        List categories = this.repository.findAllCategories();
        HashMap<String, Object> extraProperties = new HashMap<String, Object>();
        Optional optionalControlPanel = this.repository.findByName(controlPanelName);
        if (optionalControlPanel.isPresent()) {
            extraProperties.put("controlPanel", optionalControlPanel.get());
            Optional optionalCategory = this.repository.findCategoryById(((ControlPanel)optionalControlPanel.get()).getCategory().id());
            optionalCategory.ifPresent(category -> extraProperties.put("currentCategory", category));
        }
        return new Model(categories, this.applicationName, this.activeEnvironments, Model.ContentView.DETAIL, this.canRefresh, this.canStop, extraProperties);
    }
}

