/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.naming.Named;
import java.util.Objects;
import java.util.Optional;

public final class AnnotationClassValue<T>
implements CharSequence,
Named {
    private final String name;
    private final Class<T> theClass;

    public AnnotationClassValue(String name) {
        this.name = name.intern();
        this.theClass = null;
    }

    public AnnotationClassValue(Class<T> theClass) {
        this.name = theClass.getName().intern();
        this.theClass = theClass;
    }

    public Optional<Class<T>> getType() {
        return Optional.ofNullable(this.theClass);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int length() {
        return this.name.length();
    }

    @Override
    public char charAt(int index) {
        return this.name.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.name.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationClassValue that = (AnnotationClassValue)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

