/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.AnnotationSource;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.EmptyAnnotationMetadata;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.value.OptionalValues;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface AnnotationMetadata
extends AnnotationSource {
    public static final AnnotationMetadata EMPTY_METADATA = new EmptyAnnotationMetadata();
    public static final String VALUE_MEMBER = "value";
    public static final String CLASS_NAME_SUFFIX = "$$AnnotationMetadata";

    public boolean hasDeclaredAnnotation(@Nullable String var1);

    public boolean hasAnnotation(@Nullable String var1);

    public boolean hasStereotype(@Nullable String var1);

    public boolean hasDeclaredStereotype(@Nullable String var1);

    public List<String> getAnnotationNamesByStereotype(String var1);

    public Set<String> getAnnotationNames();

    public Set<String> getDeclaredAnnotationNames();

    public List<String> getDeclaredAnnotationNamesByStereotype(String var1);

    public <T> OptionalValues<T> getValues(String var1, Class<T> var2);

    public <T> Optional<T> getDefaultValue(String var1, String var2, Class<T> var3);

    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(Class<T> var1);

    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(Class<T> var1);

    @Override
    default public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.hasAnnotation(annotationClass);
    }

    @Override
    default public boolean isDeclaredAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.hasDeclaredAnnotation(annotationClass);
    }

    default public <T> Optional<T> getDefaultValue(Class<? extends Annotation> annotation, String member, Class<T> requiredType) {
        return this.getDefaultValue(annotation.getName(), member, requiredType);
    }

    default public <T> Optional<T> getValue(Class<? extends Annotation> annotation, String member, Class<T> requiredType) {
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            List<AnnotationValue<? extends Annotation>> values = this.getAnnotationValuesByType(annotation);
            if (!values.isEmpty()) {
                return values.iterator().next().get(member, requiredType);
            }
            return Optional.empty();
        }
        Optional<AnnotationValue<? extends Annotation>> values = this.findAnnotation(annotation);
        Optional value = values.flatMap(av -> av.get(member, requiredType));
        if (!value.isPresent() && this.hasStereotype(annotation)) {
            return this.getDefaultValue(annotation, member, requiredType);
        }
        return value;
    }

    default public Optional<String> getAnnotationNameByStereotype(String stereotype) {
        return this.getAnnotationNamesByStereotype(stereotype).stream().findFirst();
    }

    default public Optional<String> getDeclaredAnnotationNameByStereotype(String stereotype) {
        return this.getDeclaredAnnotationNamesByStereotype(stereotype).stream().findFirst();
    }

    default public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(Class<? extends Annotation> stereotype) {
        return this.getAnnotationTypeByStereotype(stereotype.getName());
    }

    default public Optional<Class<? extends Annotation>> getDeclaredAnnotationTypeByStereotype(Class<? extends Annotation> stereotype) {
        return this.getDeclaredAnnotationTypeByStereotype(stereotype.getName());
    }

    default public Optional<Class<? extends Annotation>> getDeclaredAnnotationTypeByStereotype(String stereotype) {
        return this.getDeclaredAnnotationNameByStereotype(stereotype).flatMap(this::getAnnotationType);
    }

    default public Optional<Class<? extends Annotation>> getAnnotationType(String name) {
        Optional<Class> aClass = ClassUtils.forName(name, this.getClass().getClassLoader());
        return aClass.flatMap(aClass1 -> {
            if (Annotation.class.isAssignableFrom((Class<?>)aClass1)) {
                return Optional.of(aClass1);
            }
            return Optional.empty();
        });
    }

    default public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(String stereotype) {
        return this.getAnnotationNameByStereotype(stereotype).flatMap(this::getAnnotationType);
    }

    default public Optional<String> getAnnotationNameByStereotype(Class<? extends Annotation> stereotype) {
        return this.getAnnotationNameByStereotype(stereotype.getName());
    }

    default public <T> OptionalValues<T> getValues(Class<? extends Annotation> annotation, Class<T> valueType) {
        return this.getValues(annotation.getName(), valueType);
    }

    default public List<String> getAnnotationNamesByStereotype(Class<? extends Annotation> stereotype) {
        return this.getAnnotationNamesByStereotype(stereotype.getName());
    }

    default public List<Class<? extends Annotation>> getAnnotationTypesByStereotype(Class<? extends Annotation> stereotype) {
        List<String> names = this.getAnnotationNamesByStereotype(stereotype.getName());
        return names.stream().map(this::getAnnotationType).filter(Optional::isPresent).map(opt -> (Class)opt.get()).collect(Collectors.toList());
    }

    @Override
    default public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(Class<T> annotation) {
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            List<AnnotationValue<T>> values = this.getAnnotationValuesByType(annotation);
            if (!values.isEmpty()) {
                return Optional.of(values.iterator().next());
            }
            return Optional.empty();
        }
        return this.findAnnotation(annotation.getName());
    }

    @Override
    default public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(Class<T> annotation) {
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            List<AnnotationValue<T>> values = this.getDeclaredAnnotationValuesByType(annotation);
            if (!values.isEmpty()) {
                return Optional.of(values.iterator().next());
            }
            return Optional.empty();
        }
        return this.findDeclaredAnnotation(annotation.getName());
    }

    default public <T> Optional<T> getValue(String annotation, String member, Class<T> requiredType) {
        Optional value = this.findAnnotation(annotation).flatMap(av -> av.get(member, requiredType));
        if (!value.isPresent() && this.hasStereotype(annotation)) {
            return this.getDefaultValue(annotation, member, requiredType);
        }
        return value;
    }

    default public OptionalLong longValue(String annotation, String member) {
        Optional<Long> result = this.getValue(annotation, member, Long.class);
        return result.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    default public Optional<Class> classValue(String annotation) {
        return this.classValue(annotation, VALUE_MEMBER);
    }

    default public Optional<Class> classValue(String annotation, String member) {
        return this.getValue(annotation, member, Class.class);
    }

    default public Optional<Class> classValue(Class<? extends Annotation> annotation) {
        return this.classValue(annotation.getName());
    }

    default public Optional<Class> classValue(Class<? extends Annotation> annotation, String member) {
        return this.classValue(annotation.getName(), member);
    }

    default public OptionalInt intValue(String annotation, String member) {
        Optional<Integer> result = this.getValue(annotation, member, Integer.class);
        return result.map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    default public OptionalDouble doubleValue(String annotation, String member) {
        Optional<Double> result = this.getValue(annotation, member, Double.class);
        return result.map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
    }

    default public <T> Optional<T> getValue(String annotation, Class<T> requiredType) {
        return this.getValue(annotation, VALUE_MEMBER, requiredType);
    }

    default public Optional<Object> getValue(String annotation, String member) {
        return this.getValue(annotation, member, Object.class);
    }

    default public Optional<Object> getValue(Class<? extends Annotation> annotation, String member) {
        return this.getValue(annotation, member, Object.class);
    }

    default public boolean isTrue(String annotation, String member) {
        return this.getValue(annotation, member, Boolean.class).orElse(false);
    }

    default public boolean isTrue(Class<? extends Annotation> annotation, String member) {
        return this.getValue(annotation.getName(), member, Boolean.class).orElse(false);
    }

    default public boolean isPresent(String annotation, String member) {
        return this.findAnnotation(annotation).map(av -> av.contains(member)).orElse(false);
    }

    default public boolean isPresent(Class<? extends Annotation> annotation, String member) {
        return this.isPresent(annotation.getName(), member);
    }

    default public boolean isFalse(Class<? extends Annotation> annotation, String member) {
        return !this.isTrue(annotation, member);
    }

    default public boolean isFalse(String annotation, String member) {
        return !this.isTrue(annotation, member);
    }

    default public Optional<Object> getValue(String annotation) {
        return this.getValue(annotation, Object.class);
    }

    default public Optional<Object> getValue(Class<? extends Annotation> annotation) {
        return this.getValue(annotation, VALUE_MEMBER, Object.class);
    }

    default public <T> Optional<T> getValue(Class<? extends Annotation> annotation, Class<T> requiredType) {
        return this.getValue(annotation, VALUE_MEMBER, requiredType);
    }

    default public boolean hasAnnotation(@Nullable Class<? extends Annotation> annotation) {
        if (annotation != null) {
            Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasAnnotation(repeatable.value());
            }
            return this.hasAnnotation(annotation.getName());
        }
        return false;
    }

    default public boolean hasStereotype(@Nullable Class<? extends Annotation> annotation) {
        if (annotation != null) {
            Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasStereotype(repeatable.value());
            }
            return this.hasStereotype(annotation.getName());
        }
        return false;
    }

    default public boolean hasStereotype(Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (!this.hasStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasStereotype(String[] annotations) {
        for (String annotation : annotations) {
            if (!this.hasStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasDeclaredAnnotation(@Nullable Class<? extends Annotation> annotation) {
        if (annotation != null) {
            Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasDeclaredAnnotation(repeatable.value());
            }
            return this.hasDeclaredAnnotation(annotation.getName());
        }
        return false;
    }

    default public boolean hasDeclaredStereotype(@Nullable Class<? extends Annotation> stereotype) {
        if (stereotype != null) {
            Repeatable repeatable = stereotype.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasDeclaredStereotype(repeatable.value());
            }
            return this.hasDeclaredStereotype(stereotype.getName());
        }
        return false;
    }

    default public boolean hasDeclaredStereotype(Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (!this.hasDeclaredStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    default public boolean isEmpty() {
        return this == EMPTY_METADATA;
    }
}

