/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Optional;
import javax.annotation.Nullable;

public interface AnnotationSource {
    public static final AnnotationSource EMPTY = new AnnotationSource(){};

    default public <T extends Annotation> T synthesize(Class<T> annotationClass) {
        return null;
    }

    default public <T extends Annotation> T synthesizeDeclared(Class<T> annotationClass) {
        return null;
    }

    default public Annotation[] synthesizeAll() {
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    default public Annotation[] synthesizeDeclared() {
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    default public <T extends Annotation> T[] synthesizeAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    default public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    default public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(String annotation) {
        return Optional.empty();
    }

    default public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(Class<T> annotation) {
        return Optional.empty();
    }

    default public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(String annotation) {
        return Optional.empty();
    }

    default public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(Class<T> annotation) {
        return Optional.empty();
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getAnnotation(String annotation) {
        return this.findAnnotation(annotation).orElse(null);
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getAnnotation(Class<T> annotation) {
        return this.findAnnotation(annotation).orElse(null);
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getDeclaredAnnotation(String annotation) {
        return this.findDeclaredAnnotation(annotation).orElse(null);
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getDeclaredAnnotation(Class<T> annotation) {
        return this.findDeclaredAnnotation(annotation).orElse(null);
    }

    default public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return false;
    }

    default public boolean isDeclaredAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return false;
    }
}

