/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.value.ValueResolver;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class AnnotationValue<A extends Annotation>
implements ValueResolver<CharSequence> {
    private final String annotationName;
    private final ConvertibleValues<Object> convertibleValues;
    private final Map<CharSequence, Object> values;
    private final Map<String, Object> defaultValues;

    public AnnotationValue(String annotationName, Map<CharSequence, Object> values) {
        this.annotationName = annotationName.intern();
        this.convertibleValues = this.newConvertibleValues(values);
        this.values = values;
        this.defaultValues = Collections.EMPTY_MAP;
    }

    public AnnotationValue(String annotationName, Map<CharSequence, Object> values, Map<String, Object> defaultValues) {
        this.annotationName = annotationName.intern();
        this.convertibleValues = this.newConvertibleValues(values);
        this.values = values;
        this.defaultValues = defaultValues != null ? defaultValues : Collections.EMPTY_MAP;
    }

    public AnnotationValue(String annotationName) {
        this.annotationName = annotationName.intern();
        this.convertibleValues = ConvertibleValues.EMPTY;
        this.values = Collections.EMPTY_MAP;
        this.defaultValues = Collections.EMPTY_MAP;
    }

    public AnnotationValue(String annotationName, ConvertibleValues<Object> convertibleValues) {
        this.annotationName = annotationName.intern();
        this.convertibleValues = convertibleValues;
        Map<String, Object> existing = convertibleValues.asMap();
        this.values = new HashMap<CharSequence, Object>(existing.size());
        this.values.putAll(existing);
        this.defaultValues = Collections.EMPTY_MAP;
    }

    @Internal
    protected AnnotationValue(AnnotationValue<A> target, Map<String, Object> defaultValues, ConvertibleValues<Object> convertibleValues) {
        this.annotationName = target.annotationName;
        this.defaultValues = defaultValues != null ? defaultValues : target.defaultValues;
        this.values = target.values;
        this.convertibleValues = convertibleValues;
    }

    @Nonnull
    public final String getAnnotationName() {
        return this.annotationName;
    }

    public final boolean contains(String member) {
        return this.values.containsKey(member);
    }

    @Nonnull
    public final Set<CharSequence> getMemberNames() {
        return this.values.keySet();
    }

    @Nonnull
    public Map<CharSequence, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Nonnull
    public ConvertibleValues<Object> getConvertibleValues() {
        return this.convertibleValues;
    }

    @Override
    public <T> Optional<T> get(CharSequence member, ArgumentConversionContext<T> conversionContext) {
        Object dv;
        Optional<T> result = this.convertibleValues.get(member, conversionContext);
        if (!result.isPresent() && (dv = this.defaultValues.get(member.toString())) != null) {
            return ConversionService.SHARED.convert(dv, conversionContext);
        }
        return result;
    }

    public <T> Optional<T> getValue(ArgumentConversionContext<T> conversionContext) {
        return this.get("value", conversionContext);
    }

    public final <T> Optional<T> getValue(Argument<T> argument) {
        return this.getValue(ConversionContext.of(argument));
    }

    public final <T> Optional<T> getValue(Class<T> type) {
        return this.getValue(ConversionContext.of(type));
    }

    @Nonnull
    public final <T> T getRequiredValue(Class<T> type) {
        return this.getRequiredValue("value", type);
    }

    @Nonnull
    public final <T> T getRequiredValue(String member, Class<T> type) {
        return this.get(member, ConversionContext.of(type)).orElseThrow(() -> new IllegalStateException("No value available for annotation member @" + this.annotationName + "[" + member + "] of type: " + type));
    }

    @Nonnull
    public final <T extends Annotation> List<AnnotationValue<T>> getAnnotations(String member, Class<T> type) {
        Object[] values = this.get(member, AnnotationValue[].class).orElse(null);
        if (ArrayUtils.isNotEmpty(values)) {
            ArrayList<AnnotationValue<T>> list = new ArrayList<AnnotationValue<T>>(values.length);
            String typeName = type.getName();
            for (Object value : values) {
                if (value == null || !((AnnotationValue)value).getAnnotationName().equals(typeName)) continue;
                list.add((AnnotationValue<T>)value);
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public final <T extends Annotation> Optional<AnnotationValue<T>> getAnnotation(String member, Class<T> type) {
        return this.getAnnotations(member, type).stream().findFirst();
    }

    public int hashCode() {
        return AnnotationUtil.calculateHashCode(this.getValues());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!AnnotationValue.class.isInstance(obj)) {
            return false;
        }
        AnnotationValue other = (AnnotationValue)AnnotationValue.class.cast(obj);
        Map<CharSequence, Object> otherValues = other.getValues();
        Map<CharSequence, Object> values = this.getValues();
        if (values.size() != otherValues.size()) {
            return false;
        }
        for (Map.Entry<CharSequence, Object> member : values.entrySet()) {
            Object otherValue;
            Object value = member.getValue();
            if (AnnotationUtil.areEqual(value, otherValue = otherValues.get(member.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static AnnotationValueBuilder<?> builder(String annotationName) {
        return new AnnotationValueBuilder(annotationName);
    }

    public static <T extends Annotation> AnnotationValueBuilder<T> builder(Class<T> annotation) {
        return new AnnotationValueBuilder(annotation);
    }

    private ConvertibleValues<Object> newConvertibleValues(Map<CharSequence, Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            return ConvertibleValues.EMPTY;
        }
        return ConvertibleValues.of(values);
    }
}

