/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.AnnotationValue;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class AnnotationValueBuilder<T extends Annotation> {
    private final String annotationName;
    private Map<CharSequence, Object> values = new HashMap<CharSequence, Object>();

    AnnotationValueBuilder(String annotationName) {
        this.annotationName = annotationName;
    }

    AnnotationValueBuilder(Class<?> annotation) {
        this.annotationName = annotation.getName();
    }

    public AnnotationValue<T> build() {
        return new AnnotationValue(this.annotationName, this.values);
    }

    public AnnotationValueBuilder<T> value(int i) {
        return this.member("value", i);
    }

    public AnnotationValueBuilder<T> values(int ... ints) {
        return this.member("value", ints);
    }

    public AnnotationValueBuilder<T> value(long i) {
        return this.member("value", i);
    }

    public AnnotationValueBuilder<T> values(long ... longs) {
        return this.member("value", longs);
    }

    public AnnotationValueBuilder<T> value(@Nullable String str) {
        return this.member("value", str);
    }

    public AnnotationValueBuilder<T> values(String ... strings) {
        return this.member("value", strings);
    }

    public AnnotationValueBuilder<T> value(boolean bool) {
        return this.member("value", bool);
    }

    public AnnotationValueBuilder<T> value(@Nullable Enum<?> enumObj) {
        return this.member("value", enumObj);
    }

    public AnnotationValueBuilder<T> values(Enum<?> ... enumObjs) {
        return this.member("value", enumObjs);
    }

    public AnnotationValueBuilder<T> value(@Nullable Class<?> type) {
        return this.member("value", type);
    }

    public AnnotationValueBuilder<T> values(Class<?> ... types) {
        return this.member("value", types);
    }

    public AnnotationValueBuilder<T> value(@Nullable AnnotationValue<?> annotation) {
        return this.member("value", annotation);
    }

    public AnnotationValueBuilder<T> values(AnnotationValue<?> ... annotations) {
        return this.member("value", annotations);
    }

    public AnnotationValueBuilder<T> member(String name, int i) {
        this.values.put(name, i);
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, int ... ints) {
        if (ints != null) {
            this.values.put(name, ints);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, long i) {
        this.values.put(name, i);
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, long ... longs) {
        if (longs != null) {
            this.values.put(name, longs);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, String str) {
        if (str != null) {
            this.values.put(name, str);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, String ... strings) {
        if (strings != null) {
            this.values.put(name, strings);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, boolean bool) {
        this.values.put(name, bool);
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, @Nullable Enum<?> enumObj) {
        if (enumObj != null) {
            this.values.put(name, enumObj);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, Enum<?> ... enumObjs) {
        if (enumObjs != null) {
            this.values.put(name, enumObjs);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, @Nullable Class<?> type) {
        if (type != null) {
            this.values.put(name, type);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, Class<?> ... types) {
        if (types != null) {
            this.values.put(name, types);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, @Nullable AnnotationValue<?> annotation) {
        if (annotation != null) {
            this.values.put(name, annotation);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, AnnotationValue<?> ... annotations) {
        if (annotations != null) {
            this.values.put(name, annotations);
        }
        return this;
    }
}

