/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.async;

import java.util.function.Supplier;

public class SupplierUtil {
    public static <T> Supplier<T> memoized(final Supplier<T> actual) {
        return new Supplier<T>(){
            Supplier<T> delegate = this::initialize;
            boolean initialized;

            @Override
            public T get() {
                return this.delegate.get();
            }

            private synchronized T initialize() {
                if (!this.initialized) {
                    Object value = actual.get();
                    this.delegate = () -> value;
                    this.initialized = true;
                }
                return this.delegate.get();
            }
        };
    }
}

