/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanInfo;
import io.micronaut.core.beans.SimpleBeanInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public final class Introspector {
    private static final Map<Class<?>, BeanInfo> theCache = new ConcurrentHashMap();

    private Introspector() {
    }

    public static void flushCaches() {
        theCache.clear();
    }

    public static void flushFromCaches(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        theCache.remove(clazz);
    }

    static <T> BeanInfo<T> getBeanInfo(Class<T> beanClass) {
        BeanInfo beanInfo = theCache.get(beanClass);
        if (beanInfo == null) {
            beanInfo = new SimpleBeanInfo(beanClass);
            theCache.put(beanClass, beanInfo);
        }
        return beanInfo;
    }
}

