/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.type.Argument;
import java.util.Optional;
import java.util.function.Function;

public interface ConversionService<Impl extends ConversionService> {
    public static final ConversionService<?> SHARED = new DefaultConversionService();

    public <S, T> Impl addConverter(Class<S> var1, Class<T> var2, Function<S, T> var3);

    public <S, T> Impl addConverter(Class<S> var1, Class<T> var2, TypeConverter<S, T> var3);

    public <T> Optional<T> convert(Object var1, Class<T> var2, ConversionContext var3);

    public <S, T> boolean canConvert(Class<S> var1, Class<T> var2);

    default public <T> Optional<T> convert(Object object, Class<T> targetType) {
        return this.convert(object, targetType, ConversionContext.DEFAULT);
    }

    default public <T> Optional<T> convert(Object object, Argument<T> targetType) {
        return this.convert(object, targetType.getType(), ConversionContext.of(targetType));
    }

    default public <T> Optional<T> convert(Object object, ArgumentConversionContext<T> context) {
        return this.convert(object, context.getArgument().getType(), context);
    }
}

