/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;

public class ResourceResolver {
    private final ResourceLoader[] resourceLoaders;

    public ResourceResolver(ResourceLoader[] resourceLoaders) {
        this.resourceLoaders = resourceLoaders;
    }

    public ResourceResolver() {
        this(new ResourceLoader[]{ClassPathResourceLoader.defaultLoader(ResourceResolver.class.getClassLoader()), FileSystemResourceLoader.defaultLoader()});
    }

    public <T extends ResourceLoader> Optional<T> getLoader(Class<T> resolverType) {
        return Arrays.stream(this.resourceLoaders).filter(rl -> resolverType.isAssignableFrom(rl.getClass())).map(rl -> rl).findFirst();
    }

    public Optional<ResourceLoader> getSupportingLoader(String prefix) {
        return Arrays.stream(this.resourceLoaders).filter(rl -> rl.supportsPrefix(prefix)).findFirst();
    }

    public Optional<ResourceLoader> getLoaderForBasePath(String basePath) {
        Optional<ResourceLoader> resourceLoader = this.getSupportingLoader(basePath);
        return resourceLoader.map(rl -> rl.forBase(basePath));
    }

    public Optional<InputStream> getResourceAsStream(String path) {
        Optional<ResourceLoader> resourceLoader = this.getSupportingLoader(path);
        if (resourceLoader.isPresent()) {
            return resourceLoader.get().getResourceAsStream(path);
        }
        return Optional.empty();
    }

    public Optional<URL> getResource(String path) {
        Optional<ResourceLoader> resourceLoader = this.getSupportingLoader(path);
        if (resourceLoader.isPresent()) {
            return resourceLoader.get().getResource(path);
        }
        return Optional.empty();
    }

    public Stream<URL> getResources(String path) {
        Optional<ResourceLoader> resourceLoader = this.getSupportingLoader(path);
        if (resourceLoader.isPresent()) {
            return resourceLoader.get().getResources(path);
        }
        return Stream.empty();
    }
}

