/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io;

import io.micronaut.core.io.Streamable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public interface Writable
extends Streamable {
    public void writeTo(Writer var1) throws IOException;

    @Override
    default public void writeTo(OutputStream outputStream) throws IOException {
        this.writeTo(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    @Override
    default public void writeTo(File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            this.writeTo(outputStream);
        }
    }

    @Override
    default public void writeTo(OutputStream outputStream, @Nullable Charset charset) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset == null ? StandardCharsets.UTF_8 : charset);
        this.writeTo(writer);
        writer.flush();
    }
}

