/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.file;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.stream.Stream;

public class DefaultFileSystemResourceLoader
implements FileSystemResourceLoader {
    private final Optional<File> baseDir;

    public DefaultFileSystemResourceLoader() {
        this.baseDir = Optional.empty();
    }

    public DefaultFileSystemResourceLoader(File baseDir) {
        this.baseDir = Optional.of(baseDir);
    }

    public DefaultFileSystemResourceLoader(String path) {
        this.baseDir = Optional.of(new File(DefaultFileSystemResourceLoader.normalize(path)));
    }

    @Override
    public Optional<InputStream> getResourceAsStream(String path) {
        File file = this.getFile(DefaultFileSystemResourceLoader.normalize(path));
        try {
            return Optional.of(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<URL> getResource(String path) {
        File file = this.getFile(DefaultFileSystemResourceLoader.normalize(path));
        if (file.exists() && file.canRead() && !file.isDirectory()) {
            try {
                URL url = file.toURI().toURL();
                return Optional.of(url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Stream<URL> getResources(String name) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support retrieving a stream of resources");
    }

    @Override
    public ResourceLoader forBase(String basePath) {
        return new DefaultFileSystemResourceLoader(basePath);
    }

    private static String normalize(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        return path;
    }

    private File getFile(String path) {
        return this.baseDir.map(dir -> new File((File)dir, path)).orElse(new File(path));
    }
}

