/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.scan;

import io.micronaut.caffeine.cache.Cache;
import io.micronaut.caffeine.cache.Caffeine;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.scan.ClassPathAnnotationScanner;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Internal
public class CachingClassPathAnnotationScanner
extends ClassPathAnnotationScanner {
    private static final int CACHE_MAX = 5;
    private final Cache<CacheKey, List<Class>> initializedObjectsByType = Caffeine.newBuilder().maximumSize(5L).expireAfterAccess(2L, TimeUnit.MINUTES).build();

    public CachingClassPathAnnotationScanner(ClassLoader classLoader) {
        super(classLoader);
    }

    public CachingClassPathAnnotationScanner() {
    }

    @Override
    protected List<Class> doScan(String annotation, String pkg) {
        return this.initializedObjectsByType.get(new CacheKey(annotation, pkg), key -> super.doScan(annotation, pkg));
    }

    private final class CacheKey
    implements Serializable {
        final String annotation;
        final String pkg;

        public CacheKey(String annotation, String pkg) {
            this.annotation = annotation;
            this.pkg = pkg;
        }
    }
}

