/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.scan;

import io.micronaut.caffeine.cache.Cache;
import io.micronaut.caffeine.cache.Caffeine;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClassPathResourceLoader
implements ClassPathResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClassPathResourceLoader.class);
    private final ClassLoader classLoader;
    private final String basePath;
    private final Cache<String, Boolean> isDirectoryCache = Caffeine.newBuilder().maximumSize(50L).build();

    public DefaultClassPathResourceLoader(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public DefaultClassPathResourceLoader(ClassLoader classLoader, String basePath) {
        this.classLoader = classLoader;
        this.basePath = this.normalize(basePath);
    }

    @Override
    public Optional<InputStream> getResourceAsStream(String path) {
        if (!this.isDirectory(path)) {
            return Optional.ofNullable(this.classLoader.getResourceAsStream(this.prefixPath(path)));
        }
        return Optional.empty();
    }

    @Override
    public Optional<URL> getResource(String path) {
        boolean isDirectory = this.isDirectory(path);
        if (!isDirectory) {
            URL url = this.classLoader.getResource(this.prefixPath(path));
            return Optional.ofNullable(url);
        }
        return Optional.empty();
    }

    @Override
    public Stream<URL> getResources(String path) {
        Enumeration<URL> all;
        try {
            all = this.classLoader.getResources(this.prefixPath(path));
        }
        catch (IOException e) {
            return Stream.empty();
        }
        Stream.Builder<URL> builder = Stream.builder();
        while (all.hasMoreElements()) {
            URL url = all.nextElement();
            builder.accept(url);
        }
        return builder.build();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ResourceLoader forBase(String basePath) {
        return new DefaultClassPathResourceLoader(this.classLoader, basePath);
    }

    private String normalize(String path) {
        if (path != null) {
            if (path.startsWith("classpath:")) {
                path = path.substring(10);
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.endsWith("/") && StringUtils.isNotEmpty(path)) {
                path = path + "/";
            }
        }
        return path;
    }

    private boolean isDirectory(String path) {
        return this.isDirectoryCache.get(path, s -> {
            boolean bl;
            block19: {
                URL url = this.classLoader.getResource(this.prefixPath(path));
                if (url != null) {
                    try {
                        URI uri = url.toURI();
                        DefaultClassPathResourceLoader defaultClassPathResourceLoader = this;
                        synchronized (defaultClassPathResourceLoader) {
                            if (uri.getScheme().equals("jar")) {
                                FileSystem fileSystem = null;
                                try {
                                    try {
                                        fileSystem = FileSystems.getFileSystem(uri);
                                    }
                                    catch (FileSystemNotFoundException e) {
                                        fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap(), this.classLoader);
                                    }
                                    Path pathObject = fileSystem.getPath(path, new String[0]);
                                    Boolean bl2 = pathObject == null || Files.isDirectory(pathObject, new LinkOption[0]);
                                    return bl2;
                                }
                                finally {
                                    block18: {
                                        if (fileSystem != null && fileSystem.isOpen()) {
                                            try {
                                                fileSystem.close();
                                            }
                                            catch (IOException e) {
                                                if (!LOG.isDebugEnabled()) break block18;
                                                LOG.debug("Error shutting down JAR file system [" + fileSystem + "]: " + e.getMessage(), (Throwable)e);
                                            }
                                        }
                                    }
                                }
                            }
                            if (uri.getScheme().equals("file")) {
                                // MONITOREXIT @DISABLED, blocks:[0, 17, 6, 14] lbl29 : MonitorExitStatement: MONITOREXIT : var6_6
                                Path pathObject = Paths.get(uri);
                                return pathObject == null || Files.isDirectory(pathObject, new LinkOption[0]);
                            }
                        }
                    }
                    catch (IOException | URISyntaxException e) {
                        if (!LOG.isDebugEnabled()) break block19;
                        LOG.debug("Error establishing whether path is a directory: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (path.indexOf(46) == -1) {
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        });
    }

    private String prefixPath(String path) {
        if (path.startsWith("classpath:")) {
            path = path.substring(10);
        }
        if (this.basePath != null) {
            if (path.startsWith("/")) {
                return this.basePath + path.substring(1);
            }
            return this.basePath + path;
        }
        return path;
    }
}

