/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.naming;

import io.micronaut.core.util.StringUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class NameUtils {
    private static final int PREFIX_LENTGH = 3;
    private static final int IS_LENTGH = 2;
    private static final Pattern DOT_UPPER = Pattern.compile("\\.[A-Z\\$]");
    private static final Pattern SERVICE_ID_REGEX = Pattern.compile("[\\p{javaLowerCase}\\d-]+");

    public static boolean isHyphenatedLowerCase(String name) {
        return StringUtils.isNotEmpty(name) && SERVICE_ID_REGEX.matcher(name).matches() && Character.isLetter(name.charAt(0));
    }

    public static String decapitalizeWithoutSuffix(String name, String ... suffixes) {
        String decapitalized = NameUtils.decapitalize(name);
        return NameUtils.trimSuffix(decapitalized, suffixes);
    }

    public static String trimSuffix(String string, String ... suffixes) {
        if (suffixes != null) {
            for (String suffix : suffixes) {
                if (!string.endsWith(suffix)) continue;
                return string.substring(0, string.length() - suffix.length());
            }
        }
        return string;
    }

    public static String capitalize(String name) {
        String rest = name.substring(1);
        if (Character.isLowerCase(name.charAt(0)) && rest.length() > 0 && Character.isUpperCase(rest.charAt(0))) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + rest;
    }

    public static String hyphenate(String name) {
        return NameUtils.hyphenate(name, true);
    }

    public static String hyphenate(String name, boolean lowerCase) {
        if (NameUtils.isHyphenatedLowerCase(name)) {
            return name.replace('_', '-');
        }
        char separatorChar = '-';
        return NameUtils.separateCamelCase(name.replace('_', '-'), lowerCase, separatorChar);
    }

    public static String dehyphenate(String name) {
        return Arrays.stream(name.split("-")).map(str -> {
            if (str.length() > 0 && Character.isLetter(str.charAt(0))) {
                return Character.toUpperCase(str.charAt(0)) + str.substring(1);
            }
            return str;
        }).collect(Collectors.joining(""));
    }

    public static String getPackageName(String className) {
        Matcher matcher = DOT_UPPER.matcher(className);
        if (matcher.find()) {
            int position = matcher.start();
            return className.substring(0, position);
        }
        return "";
    }

    public static String underscoreSeparate(String camelCase) {
        return NameUtils.separateCamelCase(camelCase.replace('-', '_'), false, '_');
    }

    public static String environmentName(String camelCase) {
        return NameUtils.separateCamelCase(camelCase.replace('-', '_').replace('.', '_'), false, '_').toUpperCase(Locale.ENGLISH);
    }

    public static String getSimpleName(String className) {
        Matcher matcher = DOT_UPPER.matcher(className);
        if (matcher.find()) {
            int position = matcher.start();
            return className.substring(position + 1);
        }
        return className;
    }

    public static boolean isSetterName(String methodName) {
        int len = methodName.length();
        if (len > 3 && methodName.startsWith("set")) {
            return Character.isUpperCase(methodName.charAt(3));
        }
        return false;
    }

    public static String getPropertyNameForSetter(String setterName) {
        if (NameUtils.isSetterName(setterName)) {
            return NameUtils.decapitalize(setterName.substring(3));
        }
        return setterName;
    }

    public static String setterNameFor(String propertyName) {
        return "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public static boolean isGetterName(String methodName) {
        int len = methodName.length();
        int prefixLength = 0;
        if (methodName.startsWith("get")) {
            prefixLength = 3;
        } else if (methodName.startsWith("is")) {
            prefixLength = 2;
        } else {
            return false;
        }
        if (len > prefixLength) {
            return Character.isUpperCase(methodName.charAt(prefixLength));
        }
        return false;
    }

    public static String getPropertyNameForGetter(String getterName) {
        if (NameUtils.isGetterName(getterName)) {
            int prefixLength = 0;
            if (getterName.startsWith("get")) {
                prefixLength = 3;
            } else if (getterName.startsWith("is")) {
                prefixLength = 2;
            }
            return NameUtils.decapitalize(getterName.substring(prefixLength));
        }
        return getterName;
    }

    public static String getterNameFor(String propertyName) {
        return "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public static String decapitalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0 || name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static String separateCamelCase(String name, boolean lowerCase, char separatorChar) {
        if (!lowerCase) {
            StringBuilder newName = new StringBuilder();
            boolean first = true;
            char last = '0';
            for (char c : name.toCharArray()) {
                if (first) {
                    newName.append(c);
                    first = false;
                } else if (Character.isUpperCase(c) && !Character.isUpperCase(last)) {
                    if (c != separatorChar) {
                        newName.append(separatorChar);
                    }
                    newName.append(c);
                } else {
                    if (c == '.') {
                        first = true;
                    }
                    if (c != separatorChar) {
                        if (last == separatorChar) {
                            newName.append(separatorChar);
                        }
                        newName.append(c);
                    }
                }
                last = c;
            }
            return newName.toString();
        }
        StringBuilder newName = new StringBuilder();
        char[] chars = name.toCharArray();
        boolean first = true;
        char last = '0';
        for (char c : chars) {
            if (Character.isLowerCase(c) || !Character.isLetter(c)) {
                first = false;
                if (c != separatorChar) {
                    if (last == separatorChar) {
                        newName.append(separatorChar);
                    }
                    newName.append(c);
                }
            } else {
                char lowerCaseChar = Character.toLowerCase(c);
                if (first) {
                    first = false;
                    newName.append(lowerCaseChar);
                } else if (Character.isUpperCase(last) || last == '.') {
                    newName.append(lowerCaseChar);
                } else {
                    newName.append(separatorChar).append(lowerCaseChar);
                }
            }
            last = c;
        }
        return newName.toString();
    }

    public static String extension(String filename) {
        int index;
        int lastWindowsPos;
        int extensionPos = filename.lastIndexOf(46);
        int lastUnixPos = filename.lastIndexOf(47);
        int lastSeparator = Math.max(lastUnixPos, lastWindowsPos = filename.lastIndexOf(92));
        int n = index = lastSeparator > extensionPos ? -1 : extensionPos;
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String camelCase(String str) {
        return NameUtils.camelCase(str, true);
    }

    public static String camelCase(String str, boolean lowerCaseFirstLetter) {
        String result = Arrays.stream(str.split("[\\s_-]")).map(NameUtils::capitalize).collect(Collectors.joining(""));
        if (lowerCaseFirstLetter) {
            return NameUtils.decapitalize(result);
        }
        return result;
    }

    public static String filename(String path) {
        int index;
        int lastWindowsPos;
        int extensionPos = path.lastIndexOf(46);
        int lastUnixPos = path.lastIndexOf(47);
        int lastSeparator = Math.max(lastUnixPos, lastWindowsPos = path.lastIndexOf(92));
        int n = index = lastSeparator > extensionPos ? path.length() : extensionPos;
        if (index == -1) {
            return "";
        }
        return path.substring(lastSeparator + 1, index);
    }
}

