/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.reflect;

import io.micronaut.core.reflect.ClassLoadingReporter;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.Toggleable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Nullable;

public class ClassUtils {
    public static final int EMPTY_OBJECT_ARRAY_HASH_CODE = Arrays.hashCode(ArrayUtils.EMPTY_OBJECT_ARRAY);
    public static final Map<String, Class> COMMON_CLASS_MAP = new HashMap<String, Class>();
    public static final String CLASS_EXTENSION = ".class";
    static final List<ClassLoadingReporter> CLASS_LOADING_REPORTERS;
    static final boolean CLASS_LOADING_REPORTER_ENABLED;

    public static String pathToClassName(String path) {
        if ((path = path.replace('/', '.')).endsWith(CLASS_EXTENSION)) {
            path = path.substring(0, path.length() - CLASS_EXTENSION.length());
        }
        return path;
    }

    public static boolean isPresent(String name, @Nullable ClassLoader classLoader) {
        return ClassUtils.forName(name, classLoader).isPresent();
    }

    public static boolean isJavaLangType(Class type) {
        String typeName = type.getName();
        return ClassUtils.isJavaLangType(typeName);
    }

    public static boolean isJavaLangType(String typeName) {
        return COMMON_CLASS_MAP.containsKey(typeName);
    }

    public static Optional<Class> getPrimitiveType(String primitiveType) {
        switch (primitiveType) {
            case "byte": {
                return Optional.of(Byte.TYPE);
            }
            case "int": {
                return Optional.of(Integer.TYPE);
            }
            case "short": {
                return Optional.of(Short.TYPE);
            }
            case "long": {
                return Optional.of(Long.TYPE);
            }
            case "float": {
                return Optional.of(Float.TYPE);
            }
            case "double": {
                return Optional.of(Double.TYPE);
            }
            case "char": {
                return Optional.of(Character.TYPE);
            }
            case "boolean": {
                return Optional.of(Boolean.TYPE);
            }
            case "void": {
                return Optional.of(Void.TYPE);
            }
        }
        return Optional.empty();
    }

    public static Optional<Class> forName(String name, @Nullable ClassLoader classLoader) {
        try {
            Optional<Class> commonType;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            if ((commonType = Optional.ofNullable(COMMON_CLASS_MAP.get(name))).isPresent()) {
                return commonType;
            }
            Class<?> type = Class.forName(name, true, classLoader);
            ClassLoadingReporter.reportPresent(type);
            return Optional.of(type);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            ClassLoadingReporter.reportMissing(name);
            return Optional.empty();
        }
    }

    public static List<Class> resolveHierarchy(Class<?> type) {
        Class<?> superclass;
        ArrayList<Class> hierarchy = new ArrayList<Class>();
        if (superclass != null) {
            ClassUtils.populateHierarchyInterfaces(type, hierarchy);
            for (superclass = type.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
                ClassUtils.populateHierarchyInterfaces(superclass, hierarchy);
            }
        } else if (type.isInterface()) {
            ClassUtils.populateHierarchyInterfaces(type, hierarchy);
        }
        if (type.isArray()) {
            if (!type.getComponentType().isPrimitive()) {
                hierarchy.add(Object[].class);
            }
        } else {
            hierarchy.add(Object.class);
        }
        return hierarchy;
    }

    private static void populateHierarchyInterfaces(Class<?> superclass, List<Class> hierarchy) {
        if (!hierarchy.contains(superclass)) {
            hierarchy.add(superclass);
        }
        for (Class<?> aClass : superclass.getInterfaces()) {
            if (!hierarchy.contains(aClass)) {
                hierarchy.add(aClass);
            }
            ClassUtils.populateHierarchyInterfaces(aClass, hierarchy);
        }
    }

    static {
        COMMON_CLASS_MAP.put(Boolean.TYPE.getName(), Boolean.TYPE);
        COMMON_CLASS_MAP.put(Byte.TYPE.getName(), Byte.TYPE);
        COMMON_CLASS_MAP.put(Integer.TYPE.getName(), Integer.TYPE);
        COMMON_CLASS_MAP.put(Long.TYPE.getName(), Long.TYPE);
        COMMON_CLASS_MAP.put(Double.TYPE.getName(), Double.TYPE);
        COMMON_CLASS_MAP.put(Float.TYPE.getName(), Float.TYPE);
        COMMON_CLASS_MAP.put(Character.TYPE.getName(), Character.TYPE);
        COMMON_CLASS_MAP.put(Short.TYPE.getName(), Short.TYPE);
        COMMON_CLASS_MAP.put(boolean[].class.getName(), boolean[].class);
        COMMON_CLASS_MAP.put(byte[].class.getName(), byte[].class);
        COMMON_CLASS_MAP.put(int[].class.getName(), int[].class);
        COMMON_CLASS_MAP.put(long[].class.getName(), long[].class);
        COMMON_CLASS_MAP.put(double[].class.getName(), double[].class);
        COMMON_CLASS_MAP.put(float[].class.getName(), float[].class);
        COMMON_CLASS_MAP.put(char[].class.getName(), char[].class);
        COMMON_CLASS_MAP.put(short[].class.getName(), short[].class);
        COMMON_CLASS_MAP.put(Boolean.class.getName(), Boolean.class);
        COMMON_CLASS_MAP.put(Byte.class.getName(), Byte.class);
        COMMON_CLASS_MAP.put(Integer.class.getName(), Integer.class);
        COMMON_CLASS_MAP.put(Long.class.getName(), Long.class);
        COMMON_CLASS_MAP.put(Short.class.getName(), Short.class);
        COMMON_CLASS_MAP.put(Double.class.getName(), Double.class);
        COMMON_CLASS_MAP.put(Float.class.getName(), Float.class);
        COMMON_CLASS_MAP.put(Character.class.getName(), Character.class);
        COMMON_CLASS_MAP.put(String.class.getName(), String.class);
        List<Object> reporterList = new ArrayList();
        try {
            ServiceLoader<ClassLoadingReporter> reporters = ServiceLoader.load(ClassLoadingReporter.class);
            for (ClassLoadingReporter reporter : reporters) {
                if (!reporter.isEnabled()) continue;
                reporterList.add(reporter);
            }
        }
        catch (Throwable e) {
            reporterList = Collections.emptyList();
        }
        CLASS_LOADING_REPORTERS = reporterList;
        CLASS_LOADING_REPORTER_ENABLED = CLASS_LOADING_REPORTERS == Collections.EMPTY_LIST ? false : reporterList.stream().anyMatch(Toggleable::isEnabled);
    }
}

