/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.reflect;

import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.exception.InstantiationException;
import java.lang.reflect.Constructor;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantiationUtils {
    public static Optional<?> tryInstantiate(String name, ClassLoader classLoader) {
        try {
            return ClassUtils.forName(name, classLoader).flatMap(InstantiationUtils::tryInstantiate);
        }
        catch (Throwable e) {
            Logger log = LoggerFactory.getLogger(InstantiationUtils.class);
            if (log.isDebugEnabled()) {
                log.debug("Tried, but could not instantiate type: " + name, e);
            }
            return Optional.empty();
        }
    }

    public static <T> Optional<T> tryInstantiate(Class<T> type) {
        try {
            T bean = type.newInstance();
            if (type.isInstance(bean)) {
                return Optional.of(bean);
            }
            return Optional.empty();
        }
        catch (Throwable e) {
            try {
                Constructor<T> defaultConstructor = type.getDeclaredConstructor(new Class[0]);
                defaultConstructor.setAccessible(true);
                return InstantiationUtils.tryInstantiate(defaultConstructor, new Object[0]);
            }
            catch (Throwable e1) {
                Logger log = LoggerFactory.getLogger(InstantiationUtils.class);
                if (log.isDebugEnabled()) {
                    log.debug("Tried, but could not instantiate type: " + type, e);
                }
                return Optional.empty();
            }
        }
    }

    public static <T> Optional<T> tryInstantiate(Constructor<T> type, Object ... args) {
        try {
            return Optional.of(type.newInstance(args));
        }
        catch (Throwable e) {
            Logger log = LoggerFactory.getLogger(InstantiationUtils.class);
            if (log.isDebugEnabled()) {
                log.debug("Tried, but could not instantiate type: " + type, e);
            }
            return Optional.empty();
        }
    }

    public static <T> T instantiate(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (Throwable e) {
            throw new InstantiationException("Could not instantiate type [" + type.getName() + "]: " + e.getMessage(), e);
        }
    }

    public static Object instantiate(String type, ClassLoader classLoader) {
        try {
            return ClassUtils.forName(type, classLoader).flatMap(InstantiationUtils::tryInstantiate).orElseThrow(() -> new InstantiationException("No class found for name: " + type));
        }
        catch (Throwable e) {
            throw new InstantiationException("Could not instantiate type [" + type + "]: " + e.getMessage(), e);
        }
    }

    public static <T> T instantiate(String type, Class<T> requiredType) {
        try {
            return (T)ClassUtils.forName(type, requiredType.getClassLoader()).flatMap(aClass -> {
                if (requiredType == aClass || requiredType.isAssignableFrom((Class<?>)aClass)) {
                    return InstantiationUtils.tryInstantiate(aClass);
                }
                return Optional.empty();
            }).orElseThrow(() -> new InstantiationException("No compatible class found for name: " + type));
        }
        catch (Throwable e) {
            throw new InstantiationException("Could not instantiate type [" + type + "]: " + e.getMessage(), e);
        }
    }
}

