/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.core.type.TypeVariableResolver;
import io.micronaut.core.util.ArrayUtils;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.stream.Collectors;

public interface Argument<T>
extends TypeVariableResolver,
Named,
AnnotationMetadataProvider {
    public static final Argument INT = Argument.of(Integer.TYPE);
    public static final Argument LONG = Argument.of(Long.TYPE);
    public static final Argument FLOAT = Argument.of(Float.TYPE);
    public static final Argument DOUBLE = Argument.of(Double.TYPE);
    public static final Argument VOID = Argument.of(Void.TYPE);
    public static final Argument BYTE = Argument.of(Byte.TYPE);
    public static final Argument BOOLEAN = Argument.of(Boolean.TYPE);
    public static final Argument CHAR = Argument.of(Character.TYPE);
    public static final Argument SHORT = Argument.of(Short.TYPE);
    public static final Argument[] ZERO_ARGUMENTS = new Argument[0];
    public static final Argument<Object> OBJECT_ARGUMENT = Argument.of(Object.class);

    @Override
    public String getName();

    public Class<T> getType();

    public boolean equalsType(Argument<?> var1);

    public int typeHashCode();

    default public String getTypeString(boolean simple) {
        Class<T> type = this.getType();
        StringBuilder returnType = new StringBuilder(simple ? type.getSimpleName() : type.getName());
        Map<String, Argument<?>> generics = this.getTypeVariables();
        if (!generics.isEmpty()) {
            returnType.append("<").append(generics.values().stream().map(arg -> arg.getTypeString(simple)).collect(Collectors.joining(", "))).append(">");
        }
        return returnType.toString();
    }

    default public boolean hasTypeVariables() {
        return !this.getTypeVariables().isEmpty();
    }

    public static Class[] toClassArray(Argument ... arguments) {
        if (ArrayUtils.isEmpty(arguments)) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] types = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Argument argument = arguments[i];
            types[i] = argument.getType();
        }
        return types;
    }

    public static String toString(Argument ... arguments) {
        StringBuilder baseString = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            Argument argument = arguments[i];
            baseString.append(argument.toString());
            if (i == arguments.length - 1) continue;
            baseString.append(',');
        }
        return baseString.toString();
    }

    public static <T> Argument<T> of(Class<T> type, String name, Argument ... typeParameters) {
        return new DefaultArgument<T>(type, name, AnnotationMetadata.EMPTY_METADATA, typeParameters);
    }

    public static <T> Argument<T> of(Class<T> type, String name, AnnotationMetadata annotationMetadata, Argument ... typeParameters) {
        return new DefaultArgument<T>(type, name, annotationMetadata, typeParameters);
    }

    public static <T> Argument<T> of(Class<T> type, String name) {
        return new DefaultArgument<T>(type, name, AnnotationMetadata.EMPTY_METADATA, ZERO_ARGUMENTS);
    }

    public static <T> Argument<T> of(Class<T> type, Argument ... typeParameters) {
        return new DefaultArgument<T>(type, type.getSimpleName(), AnnotationMetadata.EMPTY_METADATA, typeParameters);
    }

    public static <T> Argument<T> of(Class<T> type) {
        return new DefaultArgument<T>(type, NameUtils.decapitalize(type.getSimpleName()), AnnotationMetadata.EMPTY_METADATA, ZERO_ARGUMENTS);
    }

    public static <T> Argument<T> of(Class<T> type, Class<?> ... typeParameters) {
        int len;
        if (typeParameters == null) {
            return Argument.of(type);
        }
        TypeVariable<Class<T>>[] parameters = type.getTypeParameters();
        if (parameters.length != (len = typeParameters.length)) {
            throw new IllegalArgumentException("Type parameter length does not match. Required: " + parameters.length + ", Specified: " + len);
        }
        Argument[] typeArguments = new Argument[len];
        for (int i = 0; i < parameters.length; ++i) {
            TypeVariable<Class<T>> parameter = parameters[i];
            typeArguments[i] = Argument.of(typeParameters[i], parameter.getName());
        }
        return new DefaultArgument<T>(type, type.getSimpleName(), AnnotationMetadata.EMPTY_METADATA, typeArguments);
    }
}

