/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import java.util.Objects;

public class ArgumentUtils {
    public static ArgumentCheck check(Check check) {
        return new ArgumentCheck(check);
    }

    public static <T> ArgumentCheck check(String name, T value) {
        return new ArgumentCheck<T>(name, value);
    }

    @FunctionalInterface
    public static interface Check {
        public boolean condition();
    }

    public static class ArgumentCheck<T> {
        private final Check check;
        private final String name;
        private final T value;

        public ArgumentCheck(Check check) {
            this.check = check;
            this.name = null;
            this.value = null;
        }

        public ArgumentCheck(String name, T value) {
            this.check = null;
            this.name = name;
            this.value = value;
        }

        public void orElseFail(String message) {
            if (this.check != null && !this.check.condition()) {
                throw new IllegalArgumentException(message);
            }
        }

        public void notNull() {
            if (this.name != null && this.value != null) {
                Objects.requireNonNull(this.value, "Argument [" + this.name + "] cannot be null");
            }
        }
    }
}

