/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import io.micronaut.core.util.CollectionUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> T[] concat(T[] a, T ... b) {
        int aLen = a.length;
        int bLen = b.length;
        if (bLen == 0) {
            return a;
        }
        if (aLen == 0) {
            return b;
        }
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(Object[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static String toString(@Nullable Object[] array) {
        String delimiter = ",";
        return ArrayUtils.toString(delimiter, array);
    }

    public static String toString(String delimiter, @Nullable Object[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return "";
        }
        List<Object> list = Arrays.asList(array);
        return CollectionUtils.toString(delimiter, list);
    }
}

