/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.value;

import io.micronaut.core.value.OptionalValuesMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public interface OptionalValues<V>
extends Iterable<CharSequence> {
    public static final OptionalValues EMPTY_VALUES = OptionalValues.of(Object.class, Collections.EMPTY_MAP);

    public Optional<V> get(CharSequence var1);

    public Collection<V> values();

    default public boolean isEmpty() {
        return this.values().isEmpty();
    }

    default public void forEach(BiConsumer<CharSequence, ? super V> action) {
        Objects.requireNonNull(action);
        for (CharSequence k : this) {
            this.get(k).ifPresent(v -> action.accept(k, (Object)v));
        }
    }

    public static <T> OptionalValues<T> empty() {
        return EMPTY_VALUES;
    }

    public static <T> OptionalValues<T> of(Class<T> type, @Nullable Map<CharSequence, ?> values) {
        if (values == null) {
            return OptionalValues.empty();
        }
        return new OptionalValuesMap(type, values);
    }
}

