/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.value;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.value.PropertyNotFoundException;
import io.micronaut.core.value.ValueResolver;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public interface PropertyResolver
extends ValueResolver<String> {
    public boolean containsProperty(String var1);

    public boolean containsProperties(String var1);

    public <T> Optional<T> getProperty(String var1, ArgumentConversionContext<T> var2);

    default public <T> Optional<T> getProperty(String name, Argument<T> argument) {
        return this.getProperty(name, ConversionContext.of(argument));
    }

    default public <T> Optional<T> getProperty(String name, Class<T> requiredType, ConversionContext context) {
        return this.getProperty(name, context.with(Argument.of(requiredType)));
    }

    @Override
    default public <T> Optional<T> get(String name, ArgumentConversionContext<T> conversionContext) {
        return this.getProperty(name, conversionContext);
    }

    default public <T> Optional<T> getProperty(String name, Class<T> requiredType) {
        return this.getProperty(name, requiredType, (T)ConversionContext.DEFAULT);
    }

    default public <T> T getProperty(String name, Class<T> requiredType, T defaultValue) {
        return this.getProperty(name, requiredType).orElse(defaultValue);
    }

    default public <T> T getRequiredProperty(String name, Class<T> requiredType) throws PropertyNotFoundException {
        return this.getProperty(name, requiredType).orElseThrow(() -> new PropertyNotFoundException(name, requiredType));
    }

    public static String nameOf(String ... path) {
        return Arrays.stream(path).collect(Collectors.joining("."));
    }
}

