/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.resources;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.crac.CracEventPublisher;
import io.micronaut.crac.CracResourceRegistrar;
import io.micronaut.crac.OrderedResource;
import io.micronaut.http.server.netty.NettyEmbeddedServer;
import org.crac.Context;
import org.crac.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=NettyEmbeddedServer.class)
@Requirements(value={@Requires(classes={NettyEmbeddedServer.class}), @Requires(bean=CracResourceRegistrar.class)})
public class NettyEmbeddedServerResource
implements OrderedResource {
    public static final int ORDER = 0;
    private static final Logger LOG = LoggerFactory.getLogger(NettyEmbeddedServerResource.class);
    private final CracEventPublisher eventPublisher;
    private final NettyEmbeddedServer server;

    public NettyEmbeddedServerResource(CracEventPublisher eventPublisher, NettyEmbeddedServer server) {
        this.eventPublisher = eventPublisher;
        this.server = server;
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        this.eventPublisher.fireBeforeCheckpointEvents(this, () -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping netty server {}", (Object)this.server);
            }
            long beforeStart = System.nanoTime();
            this.server.stopServerOnly();
            return System.nanoTime() - beforeStart;
        });
    }

    public void afterRestore(Context<? extends Resource> context) throws Exception {
        this.eventPublisher.fireAfterRestoreEvents(this, () -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting netty server {}", (Object)this.server);
            }
            long beforeStart = System.nanoTime();
            this.server.start();
            return System.nanoTime() - beforeStart;
        });
    }

    public int getOrder() {
        return 0;
    }
}

