/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.resources.datasources.resolver;

import com.zaxxer.hikari.HikariDataSource;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.crac.CracConfiguration;
import io.micronaut.crac.resources.datasources.resolver.DataSourceResourceResolver;
import io.micronaut.crac.resources.datasources.resolver.HikariDataSourceResolver;
import io.micronaut.transaction.jdbc.DelegatingDataSource;
import jakarta.inject.Singleton;
import java.util.Optional;
import javax.sql.DataSource;
import org.crac.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(classes={DelegatingDataSource.class, HikariDataSource.class})
public class HikariDelegatingDataSourceResolver
implements DataSourceResourceResolver {
    static final int ORDER = 1;
    private static final Logger LOG = LoggerFactory.getLogger(HikariDelegatingDataSourceResolver.class);

    @Override
    @NonNull
    public Optional<Resource> resolve(@NonNull DataSource dataSource, @NonNull CracConfiguration configuration) {
        if (dataSource instanceof DelegatingDataSource) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DelegatingDataSource detected, unwrapping");
            }
            DataSource result = DelegatingDataSource.unwrapDataSource((DataSource)dataSource);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unwrapped DataSource is {}", (Object)result.getClass().getName());
            }
            return HikariDataSourceResolver.resourceForNonDelegatingDataSource(result, configuration);
        }
        return Optional.empty();
    }

    public int getOrder() {
        return 1;
    }
}

