/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.resources;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.crac.CracEventPublisher;
import io.micronaut.crac.OrderedResource;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import jakarta.inject.Singleton;
import org.crac.Context;
import org.crac.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="crac.refresh-beans", defaultValue="true", value="true")
public class RefreshEventResource
implements OrderedResource {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshEventResource.class);
    private final CracEventPublisher cracEventPublisher;
    private final ApplicationEventPublisher<RefreshEvent> refreshEventPublisher;

    public RefreshEventResource(CracEventPublisher cracEventPublisher, ApplicationEventPublisher<RefreshEvent> refreshEventPublisher) {
        this.cracEventPublisher = cracEventPublisher;
        this.refreshEventPublisher = refreshEventPublisher;
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Before checkpoint, firing events");
        }
        this.refreshEventPublisher.publishEvent((Object)new RefreshEvent());
        this.cracEventPublisher.fireBeforeCheckpointEvents(this);
    }

    public void afterRestore(Context<? extends Resource> context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("After restore, firing events");
        }
        this.cracEventPublisher.fireAfterRestoreEvents(this);
    }

    public int getOrder() {
        return 1;
    }
}

