/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.resources.datasources.resolver;

import com.zaxxer.hikari.HikariDataSource;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.crac.CracConfiguration;
import io.micronaut.crac.resources.datasources.HikariDataSourceResource;
import io.micronaut.crac.resources.datasources.resolver.DataSourceResourceResolver;
import io.micronaut.transaction.jdbc.DelegatingDataSource;
import jakarta.inject.Singleton;
import java.util.Optional;
import javax.sql.DataSource;
import org.crac.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(classes={HikariDataSource.class}, missing={DelegatingDataSource.class})
public class HikariDataSourceResolver
implements DataSourceResourceResolver {
    static final int ORDER = 1;
    private static final Logger LOG = LoggerFactory.getLogger(HikariDataSourceResolver.class);

    @Override
    @NonNull
    public Optional<Resource> resolve(@NonNull DataSource dataSource, @NonNull CracConfiguration configuration) {
        return HikariDataSourceResolver.resourceForNonDelegatingDataSource(dataSource, configuration);
    }

    static Optional<Resource> resourceForNonDelegatingDataSource(DataSource dataSource, CracConfiguration configuration) {
        return dataSource instanceof HikariDataSource ? Optional.of(dataSource).map(ds -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HikariDataSource detected, using HikariDataSourceResource");
            }
            return new HikariDataSourceResource((HikariDataSource)ds, configuration);
        }) : Optional.empty();
    }

    public int getOrder() {
        return 1;
    }
}

