/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.resources.redis;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.crac.OrderedResource;
import org.crac.Context;
import org.crac.Resource;
import org.slf4j.Logger;

@Internal
public abstract class AbstractRedisResource<T>
implements OrderedResource {
    protected final BeanContext beanContext;

    protected AbstractRedisResource(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    protected long destroyAction(T resource, Logger logger, String message) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, resource);
        }
        long beforeStart = System.nanoTime();
        this.beanContext.destroyBean(resource);
        return System.nanoTime() - beforeStart;
    }

    public void afterRestore(Context<? extends Resource> context) throws Exception {
    }
}

