/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.resources.redis;

import io.micronaut.configuration.lettuce.cache.RedisCache;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.crac.CracEventPublisher;
import io.micronaut.crac.CracResourceRegistrar;
import io.micronaut.crac.resources.redis.AbstractRedisResource;
import org.crac.Context;
import org.crac.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=RedisCache.class)
@Requirements(value={@Requires(classes={RedisCache.class}), @Requires(bean=CracResourceRegistrar.class), @Requires(property="crac.redis.cache-enabled", defaultValue="true", value="true")})
public class RedisCacheResource
extends AbstractRedisResource<RedisCache> {
    static final String ENABLED_PROPERTY = "crac.redis.cache-enabled";
    private static final Logger LOG = LoggerFactory.getLogger(RedisCacheResource.class);
    private final CracEventPublisher eventPublisher;
    private final RedisCache redisCache;

    public RedisCacheResource(BeanContext beanContext, CracEventPublisher eventPublisher, RedisCache redisCache) {
        super(beanContext);
        this.eventPublisher = eventPublisher;
        this.redisCache = redisCache;
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        this.eventPublisher.fireBeforeCheckpointEvents(this, () -> this.destroyAction(this.redisCache, LOG, "Destroying Redis cache {}"));
    }
}

