/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.resources.redis;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.micronaut.configuration.lettuce.AbstractRedisConfiguration;
import io.micronaut.configuration.lettuce.DefaultRedisConfiguration;
import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.crac.CracEventPublisher;
import io.micronaut.crac.CracResourceRegistrar;
import io.micronaut.crac.resources.redis.AbstractRedisResource;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Optional;
import org.crac.Context;
import org.crac.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=AbstractRedisConfiguration.class)
@Requirements(value={@Requires(classes={AbstractRedisConfiguration.class}), @Requires(bean=CracResourceRegistrar.class), @Requires(property="crac.redis.connection-enabled", defaultValue="true", value="true")})
public class RedisNamedConfigResource
extends AbstractRedisResource<RedisClient> {
    static final String ENABLED_PROPERTY = "crac.redis.connection-enabled";
    private static final Logger LOG = LoggerFactory.getLogger(RedisNamedConfigResource.class);
    private final CracEventPublisher eventPublisher;
    private final AbstractRedisConfiguration configuration;
    private final String name;

    public RedisNamedConfigResource(BeanContext beanContext, CracEventPublisher eventPublisher, AbstractRedisConfiguration configuration) {
        super(beanContext);
        this.eventPublisher = eventPublisher;
        this.configuration = configuration;
        this.name = configuration.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating RedisNamedConfigResource for configuration {} named '{}'", (Object)configuration.getClass().getSimpleName(), (Object)this.name);
        }
    }

    private <T> Optional<T> findBean(Class<T> beanType) {
        Qualifier qualifier = this.configuration instanceof DefaultRedisConfiguration ? Qualifiers.none() : Qualifiers.byName((String)this.name);
        return this.beanContext.findBean(beanType, qualifier);
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        this.eventPublisher.fireBeforeCheckpointEvents(this, () -> {
            long beforeStart = System.nanoTime();
            this.findBean(RedisClient.class).ifPresent(redisClient -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Destroying Redis client bean named '{}' {}", (Object)this.name, redisClient);
                }
                this.beanContext.destroyBean(redisClient);
            });
            this.findBean(StatefulRedisConnection.class).ifPresent(statefulRedisConnection -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Destroying Redis stateful connection named '{}' {}", (Object)this.name, statefulRedisConnection);
                }
                this.beanContext.destroyBean(statefulRedisConnection);
            });
            this.findBean(StatefulRedisPubSubConnection.class).ifPresent(statefulRedisPubSubConnection -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Destroying Redis stateful pubsub connection named '{}' {}", (Object)this.name, statefulRedisPubSubConnection);
                }
                this.beanContext.destroyBean(statefulRedisPubSubConnection);
            });
            return System.nanoTime() - beforeStart;
        });
    }

    public int getOrder() {
        return -1;
    }
}

