/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.crac.CracConfiguration;
import io.micronaut.crac.OrderedResource;
import io.micronaut.crac.events.AfterRestoreEvent;
import io.micronaut.crac.events.BeforeCheckpointEvent;
import jakarta.inject.Singleton;
import java.util.function.LongSupplier;

@Singleton
public class CracEventPublisher {
    private final ApplicationEventPublisher<BeforeCheckpointEvent> beforeCheckpointEventPublisher;
    private final ApplicationEventPublisher<AfterRestoreEvent> afterRestoreEventPublisher;

    public CracEventPublisher(CracConfiguration cracConfiguration, ApplicationEventPublisher<BeforeCheckpointEvent> beforeCheckpointEventPublisher, ApplicationEventPublisher<AfterRestoreEvent> afterRestoreEventPublisher) {
        this.beforeCheckpointEventPublisher = beforeCheckpointEventPublisher;
        this.afterRestoreEventPublisher = afterRestoreEventPublisher;
    }

    public void fireBeforeCheckpointEvents(@NonNull OrderedResource resource, @NonNull LongSupplier action) {
        this.beforeCheckpointEventPublisher.publishEvent((Object)new BeforeCheckpointEvent(resource, action.getAsLong()));
    }

    public void fireBeforeCheckpointEvents(@NonNull OrderedResource resource) {
        this.beforeCheckpointEventPublisher.publishEvent((Object)new BeforeCheckpointEvent(resource, 0L));
    }

    public void fireAfterRestoreEvents(@NonNull OrderedResource resource, @NonNull LongSupplier action) {
        this.afterRestoreEventPublisher.publishEvent((Object)new AfterRestoreEvent(resource, action.getAsLong()));
    }

    public void fireAfterRestoreEvents(OrderedResource resource) {
        this.afterRestoreEventPublisher.publishEvent((Object)new AfterRestoreEvent(resource, 0L));
    }
}

