/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac;

import io.micronaut.crac.CracContextProvider;
import io.micronaut.crac.CracResourceRegistrar;
import io.micronaut.crac.OrderedResource;
import jakarta.inject.Singleton;
import java.util.List;
import org.crac.Context;
import org.crac.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OrderedCracResourceRegistrar
implements CracResourceRegistrar {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedCracResourceRegistrar.class);
    private final List<OrderedResource> resources;
    private final Context<Resource> context;

    public OrderedCracResourceRegistrar(List<OrderedResource> resources, CracContextProvider contextProvider) {
        this.resources = resources;
        this.context = contextProvider.provideContext();
    }

    @Override
    public void registerResources() {
        this.resources.forEach(resource -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering CRaC resource: {}", (Object)resource.getClass().getName());
            }
            this.context.register((Resource)resource);
        });
    }
}

