/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.info;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.management.endpoint.info.InfoEndpoint;
import io.micronaut.management.endpoint.info.InfoSource;
import jakarta.inject.Singleton;
import java.util.Map;
import org.crac.management.CRaCMXBean;
import org.reactivestreams.Publisher;

@Singleton
@Requirements(value={@Requires(beans={InfoEndpoint.class}, classes={CRaCMXBean.class}), @Requires(property="endpoints.info.crac.enabled", notEquals="false", defaultValue="true")})
public class CracInfoSource
implements InfoSource {
    public Publisher<PropertySource> getSource() {
        CRaCMXBean mxBean = CRaCMXBean.getCRaCMXBean();
        Map<String, Map<String, Long>> map = Map.of("crac", Map.of("restore-time", mxBean.getRestoreTime(), "uptime-since-restore", mxBean.getUptimeSinceRestore()));
        return Publishers.just((Object)PropertySource.of((String)"crac-info", map));
    }
}

