/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.resources.datasources;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.crac.CracConfiguration;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.crac.Context;
import org.crac.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariDataSourceResource
implements Resource {
    private static final Logger LOG = LoggerFactory.getLogger(HikariDataSourceResource.class);
    private final HikariPoolMXBean poolBean;
    private final HikariDataSource dataSource;
    private final Duration datasourcePauseTimeout;

    public HikariDataSourceResource(HikariDataSource dataSource, CracConfiguration configuration) {
        this.dataSource = dataSource;
        if (!dataSource.isAllowPoolSuspension()) {
            throw new ConfigurationException(dataSource + " is not configured to allow pool suspension. This will cause problems when the application is checkpointed. Please set configuration datasources.*.allow-pool-suspension to fix this");
        }
        this.datasourcePauseTimeout = configuration.getDatasourcePauseTimeout();
        this.poolBean = dataSource.getHikariPoolMXBean();
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Suspending Hikari pool for {}", (Object)this.dataSource);
        }
        this.poolBean.suspendPool();
        this.poolBean.softEvictConnections();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Waiting {} for connections to be closed", (Object)this.datasourcePauseTimeout);
        }
        CompletableFuture<Void> awaitClosure = CompletableFuture.runAsync(this::waitForConnectionClosure);
        awaitClosure.get(this.datasourcePauseTimeout.getSeconds(), TimeUnit.SECONDS);
    }

    public void afterRestore(Context<? extends Resource> context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resuming hikari datasource {}", (Object)this.dataSource);
        }
        this.poolBean.resumePool();
    }

    private void waitForConnectionClosure() {
        while (this.poolBean.getActiveConnections() > 0) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Interrupted while waiting for connections to be closed", (Throwable)e);
                }
                Thread.currentThread().interrupt();
            }
        }
    }
}

