/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.resources.datasources;

import javax.sql.DataSource;
import org.crac.Context;
import org.crac.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnknownDataSourceResource
implements Resource {
    private static final Logger LOG = LoggerFactory.getLogger(UnknownDataSourceResource.class);
    private final DataSource dataSource;

    public UnknownDataSourceResource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Cannot suspend DataSource {}", (Object)this.dataSource.getClass().getName());
        }
    }

    public void afterRestore(Context<? extends Resource> context) throws Exception {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Cannot resume DataSource {}", (Object)this.dataSource.getClass().getName());
        }
    }
}

